import React from "react";
import { SpaceProps, PaddingProps } from "styled-system";
import { FormButtonAlignment } from "./form.config";
export interface FormProps extends SpaceProps {
    /** Alignment of buttons */
    buttonAlignment?: FormButtonAlignment;
    /** Child elements */
    children?: React.ReactNode;
    /** The total number of errors present in the form */
    errorCount?: number;
    /** Spacing between form fields, given number will be multiplied by base spacing unit (8) */
    fieldSpacing?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7;
    /** Additional buttons rendered on the left side of the save button */
    leftSideButtons?: React.ReactNode;
    /** Disable HTML5 validation */
    noValidate?: boolean;
    /** Callback passed to the form element */
    onSubmit?: React.FormEventHandler<HTMLFormElement>;
    /** Additional buttons rendered on the right side of the save button */
    rightSideButtons?: React.ReactNode;
    /** Save button to be rendered */
    saveButton?: React.ReactNode;
    /** Enables the sticky footer. */
    stickyFooter?: boolean;
    /** The total number of warnings present in the form */
    warningCount?: number;
    /** Height of the form (any valid CSS value) */
    height?: string;
    /** Applies styling for full width buttons. Please note that you will still need to pass the `fullWidth` prop to the button you compose */
    fullWidthButtons?: boolean;
    /** Padding to be set on the form footer */
    footerPadding?: PaddingProps;
}
export declare const Form: {
    ({ children, saveButton, leftSideButtons, rightSideButtons, errorCount, warningCount, onSubmit, buttonAlignment, stickyFooter, fieldSpacing, noValidate, height, fullWidthButtons, footerPadding, ...rest }: FormProps): React.JSX.Element;
    displayName: string;
};
export default Form;
