function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useMemo } from "react";
import PropTypes from "prop-types";
import { StyledFormSummary, StyledInternalSummary, StyledMessagePrefix } from "./form-summary.style";
import Icon from "../../icon";
import useLocale from "../../../hooks/__internal__/useLocale";
export const Summary = ({
  type,
  errorCount = 0,
  warningCount = 0
}) => {
  const l = useLocale();
  const messages = {
    errorCount,
    warningCount
  };
  const message = useMemo(() => l.errors.messages.formSummary(errorCount, warningCount, type), [l.errors.messages, errorCount, warningCount, type]);
  if (messages[`${type}Count`]) {
    return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(StyledMessagePrefix, null, message?.[0]), /*#__PURE__*/React.createElement(StyledInternalSummary, {
      type: type,
      "data-element": `${type}s`
    }, /*#__PURE__*/React.createElement(Icon, {
      type: type
    }), /*#__PURE__*/React.createElement("span", null, message?.[1])));
  }
  return null;
};
const FormSummary = ({
  fullWidth,
  ...props
}) => {
  return /*#__PURE__*/React.createElement(StyledFormSummary, {
    showSummary: !!(props.errorCount || props.warningCount),
    "data-element": "form-summary",
    fullWidth: fullWidth
  }, /*#__PURE__*/React.createElement(Summary, _extends({
    type: "error"
  }, props)), /*#__PURE__*/React.createElement(Summary, _extends({
    type: "warning"
  }, props)), props.children);
};
export default FormSummary;