import React from "react";
import { StyledInternalSummaryProps } from "./form-summary.style";
interface SummaryProps extends StyledInternalSummaryProps {
    errorCount?: number;
    warningCount?: number;
}
export interface FormSummaryProps {
    /** Child elements */
    children?: React.ReactNode;
    /** The total number of errors present in the form */
    errorCount?: number;
    /** The total number of warnings present in the form */
    warningCount?: number;
    /** Applies full width styling */
    fullWidth?: boolean;
}
export declare const Summary: ({ type, errorCount, warningCount, }: SummaryProps) => React.JSX.Element | null;
declare const FormSummary: ({ fullWidth, ...props }: FormSummaryProps) => React.JSX.Element;
export default FormSummary;
