import styled from "styled-components";
import Icon from "../../icon";
import addFocusStyling from "../../../style/utils/add-focus-styling";
import baseTheme from "../../../style/themes/base";
const oldFocusStyling = `
  outline: solid 1px var(--colorsSemanticFocus500);
`;
const StyledSort = styled.div`
  display: inline-flex;
  align-items: center;
  padding-left: 2px;
  padding-right: 2px;
  border-bottom: 1px solid transparent;
  position: relative;

  :hover {
    border-bottom: 1px solid;
    cursor: pointer;
  }

  :focus {
    ${({
  theme
}) => `${!theme.focusRedesignOptOut ? addFocusStyling() : /* istanbul ignore next */oldFocusStyling}`}
    border-radius: var(--borderRadius025);
  }
`;
StyledSort.defaultProps = {
  theme: baseTheme
};
const StyledSpaceHolder = styled.div`
  display: inline-block;
  width: 22px;
`;
const StyledSortIcon = styled(Icon)`
  padding-left: var(--spacing075);
  color: ${({
  iconColor
}) => `var(${iconColor})`};
`;
export { StyledSort, StyledSpaceHolder, StyledSortIcon };