import React, { useRef, useContext } from "react";
import PropTypes from "prop-types";
import Event from "../../../__internal__/utils/helpers/events";
import Typography from "../../typography";
import { StyledSort, StyledSpaceHolder, StyledSortIcon } from "./sort.style";
import guid from "../../../__internal__/utils/helpers/guid";
import useLocale from "../../../hooks/__internal__/useLocale";
import { FlatTableThemeContext } from "../flat-table.component";
export const Sort = ({
  children,
  onClick,
  sortType,
  accessibleName
}) => {
  const id = useRef(guid());
  const locale = useLocale();
  const onKeyDown = e => {
    if (Event.isEnterOrSpaceKey(e)) {
      e.preventDefault();
      return onClick?.();
    }
    return null;
  };
  const {
    colorTheme
  } = useContext(FlatTableThemeContext);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Typography, {
    screenReaderOnly: true,
    id: id.current
  }, accessibleName || locale.sort.accessibleName(children, sortType)), /*#__PURE__*/React.createElement(StyledSort, {
    role: "button",
    onKeyDown: onKeyDown,
    tabIndex: 0,
    onClick: onClick,
    sortType: sortType,
    "aria-labelledby": id.current
  }, children, sortType && /*#__PURE__*/React.createElement(StyledSortIcon, {
    type: sortType === "ascending" ? "sort_up" : "sort_down",
    iconColor: colorTheme === "dark" ? "--colorsActionMinorYang100" : "--colorActionMinor500"
  })), !sortType && /*#__PURE__*/React.createElement(StyledSpaceHolder, null));
};
export default Sort;