function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext, useEffect, useMemo, useRef, useState, useLayoutEffect } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import Event from "../../../__internal__/utils/helpers/events";
import StyledFlatTableRow from "./flat-table-row.style";
import { DrawerSidebarContext } from "../../drawer";
import FlatTableRowHeader from "../flat-table-row-header";
import FlatTableRowDraggable from "./__internal__/flat-table-row-draggable.component";
import { FlatTableThemeContext } from "../flat-table.component";
import guid from "../../../__internal__/utils/helpers/guid";
import FlatTableRowContext from "./__internal__/flat-table-row-context";
import SubRowProvider, { SubRowContext } from "./__internal__/sub-row-provider";
import { buildPositionMap } from "../__internal__";
import { FlatTableHeadContext } from "../flat-table-head/flat-table-head.component";
const FlatTableRow = /*#__PURE__*/React.forwardRef(({
  children,
  onClick,
  expandable,
  expandableArea = "wholeRow",
  expanded = false,
  highlighted,
  selected,
  subRows,
  bgColor,
  horizontalBorderColor,
  horizontalBorderSize = "small",
  id,
  draggable,
  findItem,
  moveItem,
  ...rest
}, ref) => {
  const internalId = useRef(id ? String(id) : guid());
  const [isExpanded, setIsExpanded] = useState(expanded);
  let rowRef = useRef(null);
  if (ref) {
    rowRef = ref;
  }
  const firstColumnExpandable = expandableArea === "firstColumn";
  const [leftPositions, setLeftPositions] = useState({});
  const [rightPositions, setRightPositions] = useState({});
  const [firstCellIndex, setFirstCellIndex] = useState(0);
  const [lhsRowHeaderIndex, setLhsRowHeaderIndex] = useState(-1);
  const [rhsRowHeaderIndex, setRhsRowHeaderIndex] = useState(-1);
  const [firstCellId, setFirstCellId] = useState(null);
  const [cellsArray, setCellsArray] = useState([]);
  const [tabIndex, setTabIndex] = useState(-1);
  let interactiveRowProps = {};
  useLayoutEffect(() => {
    const checkForPositionUpdates = (updated, current) => {
      const updatedKeys = Object.keys(updated);
      const currentKeys = Object.keys(current);
      if (updatedKeys.length !== currentKeys.length) {
        return true;
      }
      return updatedKeys.some(key => updated[key] !== current[key]);
    };
    const cells = rowRef.current?.querySelectorAll("th, td");
    const cellArray = Array.from(cells || []);
    setCellsArray(cellArray);
    const firstIndex = cellArray.findIndex(cell => cell.getAttribute("data-component") !== "flat-table-checkbox");
    const lhsIndex = cellArray.findIndex(cell => cell.getAttribute("data-sticky-align") === "left");
    const rhsIndex = cellArray.findIndex(cell => cell.getAttribute("data-sticky-align") === "right");
    setLhsRowHeaderIndex(lhsIndex);
    setRhsRowHeaderIndex(rhsIndex);
    if (firstIndex !== -1) {
      setFirstCellIndex(firstIndex);
      setFirstCellId(cellArray[firstIndex].getAttribute("id"));
    } else {
      setFirstCellIndex(0);
    }
    if (lhsIndex !== -1) {
      const updatedLeftPositions = buildPositionMap(cellArray.slice(0, lhsRowHeaderIndex + 1), "offsetWidth");
      if (checkForPositionUpdates(updatedLeftPositions, leftPositions)) {
        setLeftPositions(updatedLeftPositions);
      }
    }
    if (rhsIndex !== -1) {
      const updatedRightPositions = buildPositionMap(cellArray.slice(rhsRowHeaderIndex, cellArray.length).reverse(), "offsetWidth");
      if (checkForPositionUpdates(updatedRightPositions, rightPositions)) {
        setRightPositions(updatedRightPositions);
      }
    }
  }, [children, leftPositions, lhsRowHeaderIndex, rhsRowHeaderIndex, rightPositions]);
  const noStickyColumnsOverlap = useMemo(() => {
    const hasLhsColumn = lhsRowHeaderIndex !== -1;
    const hasRhsColumn = rhsRowHeaderIndex !== -1;
    if (!hasLhsColumn || !hasRhsColumn) return true;
    return lhsRowHeaderIndex < rhsRowHeaderIndex;
  }, [lhsRowHeaderIndex, rhsRowHeaderIndex]);
  !noStickyColumnsOverlap ? process.env.NODE_ENV !== "production" ? invariant(false, `Do not render a right hand side \`${FlatTableRowHeader.displayName}\` before left hand side \`${FlatTableRowHeader.displayName}\``) : invariant(false) : void 0;
  const {
    colorTheme,
    size,
    getTabStopElementId
  } = useContext(FlatTableThemeContext);
  const {
    isInSidebar
  } = useContext(DrawerSidebarContext);
  const {
    stickyOffsets
  } = useContext(FlatTableHeadContext);
  const toggleExpanded = () => setIsExpanded(!isExpanded);
  function onKeyDown(ev) {
    const isEnterOrSpaceKey = Event.isEnterKey(ev) || Event.isSpaceKey(ev);
    if (expandable && !firstColumnExpandable && document.activeElement === rowRef.current && isEnterOrSpaceKey) {
      ev.preventDefault();
      toggleExpanded();
    }
    if (isEnterOrSpaceKey && onClick) {
      onClick(ev);
    }
  }
  function handleClick(ev) {
    if (onClick) {
      onClick(ev);
    }
    if (expandable && !firstColumnExpandable) {
      toggleExpanded();
    }
  }
  if (onClick || expandable) {
    interactiveRowProps = {
      isRowInteractive: !firstColumnExpandable,
      tabIndex: firstColumnExpandable ? undefined : tabIndex,
      onKeyDown,
      isFirstColumnInteractive: firstColumnExpandable,
      isExpanded
    };
  }
  function handleCellKeyDown(ev) {
    const isEnterOrSpaceKey = Event.isEnterKey(ev) || Event.isSpaceKey(ev);
    if (isEnterOrSpaceKey) {
      ev.preventDefault();
      toggleExpanded();
    }
  }
  useEffect(() => {
    setIsExpanded(expanded);
  }, [expanded]);
  useEffect(() => {
    setTabIndex(getTabStopElementId() === internalId.current ? 0 : -1);
  }, [getTabStopElementId]);
  const {
    isSubRow,
    firstRowId,
    addRow,
    removeRow
  } = useContext(SubRowContext);
  useEffect(() => {
    const rowId = internalId.current;
    addRow(rowId);
    return () => {
      removeRow(rowId);
    };
  }, [addRow, removeRow]);
  const isFirstSubRow = firstRowId === internalId.current;
  const rowComponent = () => /*#__PURE__*/React.createElement(StyledFlatTableRow, _extends({
    isInSidebar: isInSidebar,
    expandable: expandable,
    isSubRow: isSubRow,
    isFirstSubRow: isFirstSubRow,
    "data-element": isSubRow ? "flat-table-sub-row" : "flat-table-row",
    highlighted: highlighted,
    selected: selected,
    onClick: handleClick,
    firstCellIndex: firstCellIndex,
    ref: rowRef,
    lhsRowHeaderIndex: lhsRowHeaderIndex,
    rhsRowHeaderIndex: rhsRowHeaderIndex,
    colorTheme: colorTheme,
    size: size,
    stickyOffset: stickyOffsets[internalId.current],
    bgColor: bgColor,
    horizontalBorderColor: horizontalBorderColor,
    horizontalBorderSize: horizontalBorderSize,
    draggable: draggable,
    totalChildren: cellsArray.length,
    id: internalId.current,
    "data-selected": selected && expandableArea === "wholeRow",
    "data-highlighted": highlighted && expandableArea === "wholeRow",
    rowHeight: rowRef?.current?.offsetHeight
  }, interactiveRowProps, rest), /*#__PURE__*/React.createElement(FlatTableRowContext.Provider, {
    value: {
      firstCellId,
      expandable,
      leftPositions,
      rightPositions,
      firstColumnExpandable,
      onKeyDown: handleCellKeyDown,
      onClick: () => toggleExpanded(),
      highlighted,
      selected
    }
  }, children));
  const draggableComponent = () => /*#__PURE__*/React.createElement(FlatTableRowDraggable, {
    id: internalId.current,
    moveItem: moveItem,
    findItem: findItem,
    rowRef: rowRef
  }, rowComponent());
  return /*#__PURE__*/React.createElement(React.Fragment, null, draggable ? draggableComponent() : rowComponent(), isExpanded && subRows && /*#__PURE__*/React.createElement(SubRowProvider, null, subRows));
});
if (process.env.NODE_ENV !== "production") {
  FlatTableRow.propTypes = {
    "bgColor": PropTypes.string,
    "children": PropTypes.node,
    "draggable": PropTypes.bool,
    "expandable": PropTypes.bool,
    "expandableArea": PropTypes.oneOf(["firstColumn", "wholeRow"]),
    "expanded": PropTypes.bool,
    "findItem": PropTypes.func,
    "highlighted": PropTypes.bool,
    "horizontalBorderColor": PropTypes.string,
    "horizontalBorderSize": PropTypes.oneOf(["large", "medium", "small"]),
    "id": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "moveItem": PropTypes.func,
    "onClick": PropTypes.func,
    "selected": PropTypes.bool,
    "subRows": PropTypes.node
  };
}
export { FlatTableRow };
FlatTableRow.displayName = "FlatTableRow";
export default FlatTableRow;