import React, { createContext, useCallback, useState } from "react";
export const SubRowContext = /*#__PURE__*/createContext({
  isSubRow: false,
  firstRowId: "",
  addRow: () => {},
  removeRow: () => {}
});
const SubRowProvider = ({
  children
}) => {
  const [rowIds, setRowIds] = useState([]);
  const addRow = useCallback(id => {
    setRowIds(p => [...p, id]);
  }, []);
  const removeRow = useCallback(id => {
    setRowIds(p => p.filter(rowId => rowId !== id));
  }, []);
  return /*#__PURE__*/React.createElement(SubRowContext.Provider, {
    value: {
      isSubRow: true,
      firstRowId: rowIds[0],
      addRow,
      removeRow
    }
  }, children);
};
SubRowProvider.displayName = "SubRowProvider";
export default SubRowProvider;