import React from "react";
import PropTypes from "prop-types";
import { useDrop, useDrag } from "react-dnd";
const FlatTableRowDraggable = ({
  children,
  id,
  findItem,
  moveItem,
  rowRef
}) => {
  const originalIndex = Number(findItem?.(id).index);
  const [{
    isDragging
  }, drag] = useDrag({
    type: "flatTableRow",
    item: {
      id,
      originalIndex
    },
    collect: monitor => ({
      isDragging: monitor.isDragging()
    }),
    end: (dropResult, monitor) => {
      const {
        id: droppedId,
        originalIndex: oIndex
      } = monitor.getItem();
      const didDrop = monitor.didDrop();
      if (!didDrop) {
        moveItem?.(droppedId, Number(oIndex));
      }
    }
  });
  const [, drop] = useDrop({
    accept: "flatTableRow",
    canDrop: () => false,
    hover(item) {
      if (item?.id !== id && findItem) {
        const {
          index: overIndex
        } = findItem(id);
        moveItem?.(item?.id, Number(overIndex));
      }
    }
  });
  return /*#__PURE__*/React.cloneElement(children, {
    key: originalIndex,
    id,
    isDragging,
    ref: node => {
      drag(drop(node));
      /* istanbul ignore else */
      if (rowRef) {
        if (typeof rowRef === "function") {
          rowRef(node);
        } else {
          rowRef.current = node;
        }
      }
    }
  });
};
if (process.env.NODE_ENV !== "production") {
  FlatTableRowDraggable.propTypes = {
    "children": PropTypes.node,
    "draggable": PropTypes.bool,
    "findItem": PropTypes.func,
    "id": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "moveItem": PropTypes.func,
    "rowRef": PropTypes.oneOfType([PropTypes.func, PropTypes.shape({
      "current": PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.object]).isRequired
    })])
  };
}
export { FlatTableRowDraggable };
FlatTableRowDraggable.displayName = "FlatTableRowDraggable";
export default FlatTableRowDraggable;