function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useRef } from "react";
import PropTypes from "prop-types";
import Icon from "../../icon";
import { StyledFlatTableRowHeader, StyledFlatTableRowHeaderContent } from "./flat-table-row-header.style";
import guid from "../../../__internal__/utils/helpers/guid";
import tagComponent from "../../../__internal__/utils/helpers/tags/tags";
import useTableCell from "../__internal__/use-table-cell";
export const FlatTableRowHeader = ({
  align = "left",
  children,
  width,
  py,
  px,
  truncate,
  title,
  stickyAlignment = "left",
  colspan,
  rowspan,
  id,
  ...rest
}) => {
  const internalId = useRef(id || guid());
  const {
    leftPosition,
    rightPosition,
    expandable,
    onClick,
    onKeyDown,
    isFirstCell,
    isExpandableCell,
    tabIndex,
    isInHighlightedRow,
    isInSelectedRow
  } = useTableCell(internalId.current);
  const handleOnClick = useCallback(ev => {
    if (isExpandableCell && onClick) onClick(ev);
  }, [isExpandableCell, onClick]);
  const handleOnKeyDown = useCallback(ev => {
    if (isExpandableCell && onKeyDown) {
      onKeyDown(ev);
    }
  }, [isExpandableCell, onKeyDown]);
  return /*#__PURE__*/React.createElement(StyledFlatTableRowHeader, _extends({
    leftPosition: stickyAlignment === "left" ? leftPosition || 0 : undefined,
    rightPosition: stickyAlignment === "right" ? rightPosition || 0 : undefined,
    align: align
  }, tagComponent("flat-table-row-header", {
    "data-element": "flat-table-row-header",
    ...rest
  }), {
    width: width,
    py: py || "10px",
    px: px || 3,
    onClick: handleOnClick,
    tabIndex: isExpandableCell ? tabIndex : undefined,
    onKeyDown: handleOnKeyDown,
    truncate: truncate,
    expandable: expandable,
    stickyAlignment: stickyAlignment
  }, colspan !== undefined && {
    colSpan: Number(colspan)
  }, rowspan !== undefined && {
    rowSpan: Number(rowspan)
  }, {
    "data-selected": isInSelectedRow && isExpandableCell,
    "data-highlighted": isInHighlightedRow && isExpandableCell
  }, rest, {
    id: internalId.current
  }), /*#__PURE__*/React.createElement(StyledFlatTableRowHeaderContent, {
    title: truncate && !title && typeof children === "string" ? children : title,
    expandable: expandable
  }, expandable && isFirstCell && /*#__PURE__*/React.createElement(Icon, {
    type: "chevron_down_thick",
    mr: "8px"
  }), children));
};
FlatTableRowHeader.displayName = "FlatTableRowHeader";
export default FlatTableRowHeader;