function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef, useContext } from "react";
import PropTypes from "prop-types";
import StyledFlatTableHeader from "./flat-table-header.style";
import { FlatTableThemeContext } from "../flat-table.component";
import guid from "../../../__internal__/utils/helpers/guid";
import useTableCell from "../__internal__/use-table-cell";
export const FlatTableHeader = ({
  align = "left",
  children,
  colspan,
  rowspan,
  width,
  py,
  px,
  id,
  ...rest
}) => {
  const ref = useRef(null);
  const internalId = useRef(id || guid());
  const {
    colorTheme
  } = useContext(FlatTableThemeContext);
  const {
    leftPosition,
    rightPosition,
    makeCellSticky
  } = useTableCell(internalId.current);
  return /*#__PURE__*/React.createElement(StyledFlatTableHeader, _extends({
    ref: ref,
    leftPosition: leftPosition,
    rightPosition: rightPosition,
    makeCellSticky: makeCellSticky,
    className: makeCellSticky ? "isSticky" : undefined,
    align: align,
    colorTheme: colorTheme,
    "data-element": "flat-table-header"
  }, colspan !== undefined && {
    colSpan: Number(colspan)
  }, rowspan !== undefined && {
    rowSpan: Number(rowspan)
  }, {
    colWidth: width,
    py: py,
    px: px
  }, rest, {
    id: internalId.current
  }), /*#__PURE__*/React.createElement("div", null, children));
};
FlatTableHeader.displayName = "FlatTableHeader";
export default FlatTableHeader;