function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useEffect, useState, useRef } from "react";
import PropTypes from "prop-types";
import StyledFlatTableHead from "./flat-table-head.style";
import { buildPositionMap } from "../__internal__";
export const FlatTableHeadContext = /*#__PURE__*/React.createContext({
  stickyOffsets: {}
});
export const FlatTableHead = ({
  children,
  ...rest
}) => {
  const ref = useRef(null);
  const [stickyOffsets, setStickyOffsets] = useState({});
  useEffect(() => {
    const headerRows = ref.current?.querySelectorAll("tr");

    /* istanbul ignore else */
    if (headerRows) {
      setStickyOffsets(buildPositionMap(Array.from(headerRows), "offsetHeight"));
    } else {
      setStickyOffsets({});
    }
  }, [children]);
  return /*#__PURE__*/React.createElement(StyledFlatTableHead, _extends({
    ref: ref
  }, rest), /*#__PURE__*/React.createElement(FlatTableHeadContext.Provider, {
    value: {
      stickyOffsets
    }
  }, children));
};
export default FlatTableHead;