function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext, useRef } from "react";
import PropTypes from "prop-types";
import StyledFlatTableCheckbox from "./flat-table-checkbox.style";
import { Checkbox } from "../../checkbox";
import Events from "../../../__internal__/utils/helpers/events/events";
import tagComponent from "../../../__internal__/utils/helpers/tags";
import guid from "../../../__internal__/utils/helpers/guid";
import FlatTableRowContext from "../flat-table-row/__internal__/flat-table-row-context";
export const FlatTableCheckbox = ({
  as = "td",
  checked,
  onChange,
  selectable = true,
  onClick,
  ariaLabelledBy,
  id,
  ...rest
}) => {
  const ref = useRef(null);
  const internalId = useRef(id || guid());
  const {
    leftPositions,
    rightPositions
  } = useContext(FlatTableRowContext);
  const leftPosition = leftPositions[internalId.current];
  const rightPosition = rightPositions[internalId.current];
  const makeCellSticky = leftPosition !== undefined || rightPosition !== undefined;
  const dataElement = `flat-table-checkbox-${as === "td" ? "cell" : "header"}`;
  const handleClick = event => {
    event.stopPropagation();
    if (onClick) onClick(event);
  };
  const handleKeyDown = event => {
    if (!Events.isDownKey(event) && !Events.isUpKey(event)) {
      event.stopPropagation();
    }
  };
  return /*#__PURE__*/React.createElement(StyledFlatTableCheckbox, _extends({
    ref: ref,
    makeCellSticky: makeCellSticky,
    className: makeCellSticky ? "isSticky" : undefined,
    leftPosition: leftPosition,
    rightPosition: rightPosition,
    as: as
  }, tagComponent("flat-table-checkbox", {
    "data-element": dataElement,
    ...rest
  }), {
    id: internalId.current
  }), selectable && /*#__PURE__*/React.createElement(Checkbox, {
    checked: checked,
    onChange: onChange,
    name: "flat-table-checkbox",
    mb: 0,
    ariaLabelledBy: ariaLabelledBy,
    onClick: handleClick,
    onKeyDown: handleKeyDown
  }));
};
FlatTableCheckbox.displayName = "FlatTableCheckbox";
export default FlatTableCheckbox;