import React from "react";
import { TagProps } from "../../../__internal__/utils/helpers/tags";
export interface FlatTableCheckboxProps extends TagProps {
    /** Prop to polymorphically render either a 'th' or 'td' element */
    as?: "td" | "th";
    /** Prop to set checked prop on Checkbox */
    checked?: boolean;
    /** Callback to be called onChange in Checkbox */
    onChange?: (ev: React.ChangeEvent<HTMLElement>) => void;
    /** Whether to render the checkbox or not, defaults to true */
    selectable?: boolean;
    /** Callback function to be called when click event received */
    onClick?: (ev: React.MouseEvent<HTMLElement>) => void;
    /** The id of the element that labels the input */
    ariaLabelledBy?: string;
    /** Sets an id string on the element */
    id?: string;
}
export declare const FlatTableCheckbox: {
    ({ as, checked, onChange, selectable, onClick, ariaLabelledBy, id, ...rest }: FlatTableCheckboxProps): React.JSX.Element;
    displayName: string;
};
export default FlatTableCheckbox;
