function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef } from "react";
import PropTypes from "prop-types";
import { StyledFlatTableCell, StyledCellContent } from "./flat-table-cell.style";
import Icon from "../../icon";
import guid from "../../../__internal__/utils/helpers/guid";
import useTableCell from "../__internal__/use-table-cell";
export const FlatTableCell = ({
  align = "left",
  children,
  pl,
  width,
  truncate = false,
  title,
  colspan,
  rowspan,
  id,
  ...rest
}) => {
  const internalId = useRef(id || guid());
  const {
    leftPosition,
    rightPosition,
    expandable,
    onClick,
    onKeyDown,
    isFirstCell,
    isExpandableCell,
    makeCellSticky,
    isInHighlightedRow,
    isInSelectedRow,
    tabIndex
  } = useTableCell(internalId.current);
  return /*#__PURE__*/React.createElement(StyledFlatTableCell, _extends({
    leftPosition: leftPosition,
    rightPosition: rightPosition,
    makeCellSticky: makeCellSticky,
    className: makeCellSticky ? "isSticky" : undefined,
    align: align,
    "data-element": "flat-table-cell",
    pl: pl,
    onClick: isExpandableCell ? onClick : undefined,
    tabIndex: isExpandableCell ? tabIndex : undefined,
    onKeyDown: isExpandableCell ? onKeyDown : undefined,
    colWidth: width,
    isTruncated: truncate,
    expandable: expandable
  }, colspan !== undefined && {
    colSpan: Number(colspan)
  }, rowspan !== undefined && {
    rowSpan: Number(rowspan)
  }, {
    "data-selected": isInSelectedRow && isExpandableCell,
    "data-highlighted": isInHighlightedRow && isExpandableCell
  }, rest, {
    id: internalId.current
  }), /*#__PURE__*/React.createElement(StyledCellContent, {
    title: truncate && !title && typeof children === "string" ? children : title,
    expandable: expandable
  }, expandable && isFirstCell && /*#__PURE__*/React.createElement(Icon, {
    type: "chevron_down_thick",
    mr: "8px"
  }), children));
};
FlatTableCell.displayName = "FlatTableCell";
export default FlatTableCell;