import React from "react";
import { PaddingProps } from "styled-system";
import { TableBorderSize, TableCellAlign } from "..";
export interface FlatTableCellProps extends PaddingProps {
    /** Content alignment */
    align?: TableCellAlign;
    /** Cell content */
    children?: React.ReactNode;
    /** Number of columns that a cell should span */
    colspan?: number | string;
    /** Number of rows that a cell should span */
    rowspan?: number | string;
    /** Column width, pass a number to set a fixed width in pixels */
    width?: number;
    /** Truncate cell content and add ellipsis to any text that overflows */
    truncate?: boolean;
    /** Title text to display if cell content truncates */
    title?: string;
    /** Sets a custom vertical right border */
    verticalBorder?: TableBorderSize;
    /** Sets the color of the right border */
    verticalBorderColor?: string;
    /** Sets an id string on the element */
    id?: string;
}
export declare const FlatTableCell: {
    ({ align, children, pl, width, truncate, title, colspan, rowspan, id, ...rest }: FlatTableCellProps): React.JSX.Element;
    displayName: string;
};
export default FlatTableCell;
