function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useEffect, useState, useRef } from "react";
import PropTypes from "prop-types";
import { useDrop, DndProvider } from "react-dnd";
import { HTML5Backend } from "react-dnd-html5-backend";
import StyledIcon from "../../icon/icon.style";
import StyledFlatTableBodyDraggable from "./flat-table-body-draggable.style";
import FlatTableCell from "../flat-table-cell/flat-table-cell.component";
const DropTarget = ({
  children,
  getOrder,
  ...rest
}) => {
  const [isDragging, setIsDragging] = useState(false);
  const [, drop] = useDrop({
    accept: "flatTableRow",
    hover: (_, monitor) => {
      if (!isDragging && monitor.isOver()) setIsDragging(true);
    },
    drop(details) {
        setIsDragging(false);
 -      getOrder?.();
 +      getOrder?.(details);
      }
  });
  return /*#__PURE__*/React.createElement(StyledFlatTableBodyDraggable, _extends({
    "data-role": "flat-table-body-draggable",
    ref: drop,
    isDragging: isDragging
  }, rest), children);
};
export const FlatTableBodyDraggable = ({
  children,
  getOrder,
  ...rest
}) => {
  const [draggableItems, setDraggableItems] = useState(React.Children.toArray(children));
  const isFirstRender = useRef(true);
  useEffect(() => {
    if (!isFirstRender.current) {
      setDraggableItems(React.Children.toArray(children));
    } else {
      isFirstRender.current = false;
    }
  }, [children]);
  const findItem = id => {
    const draggableItem = draggableItems.filter(item => /*#__PURE__*/React.isValidElement(item) && `${item.props.id}` === id)[0];
    return {
      draggableItem,
      index: draggableItems.indexOf(draggableItem)
    };
  };
  const moveItem = (id, atIndex) => {
    const {
      draggableItem,
      index
    } = findItem(id);
    if (!draggableItem) return;
    const copyOfDraggableItems = [...draggableItems];
    copyOfDraggableItems.splice(index, 1);
    copyOfDraggableItems.splice(atIndex, 0, draggableItem);
    setDraggableItems(copyOfDraggableItems);
  };
  
  const getItemsId = (details) => {
    if (!getOrder) {
      return;
    }
    const draggableItemIds = draggableItems.map(draggableItem => /*#__PURE__*/React.isValidElement(draggableItem) && draggableItem.props.id);
-    getOrder(draggableItemIds);
+    getOrder(draggableItemIds, details);
  };
  return /*#__PURE__*/React.createElement(DndProvider, {
    backend: HTML5Backend
  }, /*#__PURE__*/React.createElement(DropTarget, _extends({
    getOrder: getItemsId
  }, rest), draggableItems.map(item => /*#__PURE__*/React.isValidElement(item) && /*#__PURE__*/React.cloneElement(item, {
    id: `${item.props.id}`,
    moveItem,
    findItem,
    draggable: true
  }, [/*#__PURE__*/React.createElement(FlatTableCell, {
    key: item.props.id
  }, /*#__PURE__*/React.createElement(StyledIcon, {
    type: "drag"
  })), item.props.children]))));
};
export default FlatTableBodyDraggable;