import React from "react";
import { MarginProps } from "styled-system";
import { ValidationProps } from "../../__internal__/validations";
import { InputProps } from "../../__internal__/input";
import { TagProps } from "../../__internal__/utils/helpers/tags";
import { FileUploadStatusProps } from "./__internal__/file-upload-status";
export interface FileInputProps extends Pick<ValidationProps, "error">, Pick<InputProps, "id" | "name" | "required">, TagProps, MarginProps {
    /** Which file format(s) to accept. Will be passed to the underlying HTML input.
     * See https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/accept  */
    accept?: string;
    /** Text to appear on the main button. Defaults to "Select file" */
    buttonText?: string;
    /** Explanatory text to appear inside the input area. Defaults to "or drag and drop your file" */
    dragAndDropText?: string;
    /** A hint string rendered before the input but after the label. Intended to describe the purpose or content of the input. */
    inputHint?: React.ReactNode;
    /** Sets the default layout to vertical - with the button below the explanatory text rather than next to it.
     * This is the equivalent of removing the maxHeight prop - it will be over-ridden if this prop is set explicitly. */
    isVertical?: boolean;
    /** Label content */
    label?: string;
    /** A valid CSS string for the max-height CSS property. */
    maxHeight?: string;
    /** A valid CSS string for the max-width CSS property. Defaults to the same as the minWidth. */
    maxWidth?: string;
    /** A valid CSS string for the min-height CSS property. */
    minHeight?: string;
    /** A valid CSS string for the min-width CSS property. */
    minWidth?: string;
    /** onChange event handler. Accepts a list of all files currently entered to the input. */
    onChange: (files: FileList) => void;
    /** used to control how to display the progress of uploaded file(s) within the component */
    uploadStatus?: FileUploadStatusProps | FileUploadStatusProps[];
    /** Flag to configure component as mandatory. */
    required?: boolean;
    /** Flag to configure component as optional. */
    isOptional?: boolean;
}
export declare const FileInput: React.ForwardRefExoticComponent<FileInputProps & React.RefAttributes<HTMLInputElement>>;
export default FileInput;
