import styled, { css } from "styled-components";
import StyledTypography from "../../../typography/typography.style";
import StyledIcon from "../../../icon/icon.style";
import { StyledProgressBar, InnerBar as ProgressTrackerInnerBar } from "../../../progress-tracker/progress-tracker.style";
import StyledLoaderBar, { StyledLoader, InnerBar as LoaderBarInnerBar } from "../../../loader-bar/loader-bar.style";
import { StyledLink, StyledContent } from "../../../link/link.style";
export const StyledFileLinkContainer = styled.div`
  color: var(--colorsActionMajorYin090);
  display: flex;
  align-items: center;
  overflow-x: clip;
  overflow-y: visible;
  padding-right: var(--spacing150);

  ${StyledLink} {
    overflow: hidden;
  }

  ${StyledLink} a {
    overflow: hidden;
    display: flex;
    text-decoration: none;
  }

  ${StyledContent} {
    overflow: hidden;
    text-overflow: ellipsis;
    text-decoration: underline;
  }

  &&& ${StyledIcon} {
    display: inline-flex;
    justify-content: center;
    align-items: flex-start;
    width: 24px;
    height: 24px;

    // only apply these styles when the icon is not part of a Link component
    :not(${StyledLink} ${StyledIcon}) {
      color: var(--colorsUtilityYin065);
      padding-right: var(--spacing100);
    }
  }
`;
export const StyledFileUploadStatusRow = styled.div`
  display: flex;
  justify-content: space-between;
  ${({
  onlyRow
}) => onlyRow ? "" : "align-items: baseline;"}
  padding-left: var(--spacing150);
  ${({
  upperPadding
}) => upperPadding ? "padding-top: var(--spacing050);" : ""}
  ${({
  lowerPadding
}) => lowerPadding ? "padding-bottom: var(--spacing125);" : ""}

  ${StyledTypography} {
    color: var(--colorsUtilityYin055);
  }
`;
export const StyledFileUploadStatus = styled.div`
  background-color: var(--colorsUtilityYang100);
  ${({
  hasError
}) => {
  const borderWidthToken = hasError ? "borderWidth200" : "borderWidth100";
  const colorToken = hasError ? "colorsSemanticNegative500" : "colorsUtilityMajor300";
  return css`
      border: var(--${borderWidthToken}) solid var(--${colorToken});
      ${hasError && `&& ${StyledTypography} {
        color: var(--${colorToken});
        font-weight: 500;
      }`}
    `;
}}
  border-radius: var(--borderRadius050);

  ${StyledProgressBar}, ${ProgressTrackerInnerBar} {
    border-radius: var(--borderRadius050);
    border: none;
  }

  ${StyledLoader} {
    display: flex;
  }

  ${StyledLoaderBar} {
    background-color: var(--colorsSemanticNeutral200);
  }

  ${LoaderBarInnerBar} {
    background-color: var(--colorsSemanticNeutral500);
    border-radius: var(--borderRadius050);
  }
`;