import React from "react";
import PropTypes from "prop-types";
import Link from "../../../link";
import ButtonMinor from "../../../button-minor";
import StyledTypography from "../../../typography/typography.style";
import ProgressTracker from "../../../progress-tracker";
import LoaderBar from "../../../loader-bar";
import Icon from "../../../icon";
import { StyledFileUploadStatus, StyledFileUploadStatusRow, StyledFileLinkContainer } from "./file-upload-status.style";
import useLocale from "../../../../hooks/__internal__/useLocale";
export const FileUploadStatus = ({
  status,
  filename,
  message,
  onAction,
  iconType = "file_generic",
  ...statusProps
}) => {
  const locale = useLocale();
  const statusMessage = message || locale.fileInput.fileUploadStatus();
  let buttonText;
  let linkProps;
  let progressBar = null;
  switch (status) {
    case "uploading":
      buttonText = locale.fileInput.actions.cancel();
      progressBar = statusProps.progress === undefined ? /*#__PURE__*/React.createElement(LoaderBar, null) : /*#__PURE__*/React.createElement(ProgressTracker, {
        progress: statusProps.progress,
        length: "100%"
      });
      break;
    case "previously":
    case "completed":
      buttonText = locale.fileInput.actions.delete();
      linkProps = {
        ...statusProps,
        icon: iconType
      };
      break;
    case "error":
      buttonText = locale.fileInput.actions.clear();
      break;
    // istanbul ignore next
    default:
      // no other cases if consumers are using TS, but ESLint still insists on it
      break;
  }
  const actionButton = /*#__PURE__*/React.createElement(ButtonMinor, {
    onClick: onAction,
    buttonType: "tertiary"
  }, buttonText);
  const fileLink = linkProps ? /*#__PURE__*/React.createElement(Link, linkProps, filename) : /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Icon, {
    type: iconType
  }), /*#__PURE__*/React.createElement("span", null, filename));
  const mainRow = status !== "previously" ? /*#__PURE__*/React.createElement(StyledFileUploadStatusRow, null, /*#__PURE__*/React.createElement(StyledTypography, {
    as: "p",
    mb: 0,
    "aria-live": "polite"
  }, statusMessage), actionButton) : /*#__PURE__*/React.createElement(StyledFileUploadStatusRow, {
    onlyRow: true
  }, /*#__PURE__*/React.createElement(StyledFileLinkContainer, null, fileLink), actionButton);
  const secondRow = status !== "previously" ? /*#__PURE__*/React.createElement(StyledFileUploadStatusRow, {
    upperPadding: true,
    lowerPadding: true
  }, /*#__PURE__*/React.createElement(StyledFileLinkContainer, null, fileLink)) : null;
  return /*#__PURE__*/React.createElement(StyledFileUploadStatus, {
    hasError: status === "error"
  }, mainRow, secondRow, progressBar);
};
export default FileUploadStatus;