import React from "react";
import { LinkProps } from "../../../link";
import { IconType } from "../../../icon";
interface StatusUploadingProps {
    /** the status of the upload */
    status: "uploading";
    /** a number from 0-100 giving the current upload progress as a percentage. Only used for the `uploading` status.
     * If the progress prop is not specified in the `uploading` status, a loading animation will be shown instead
     * (or text equivalent for users with a reduced-motion operating system preference).
     */
    progress?: number;
}
interface StatusDoneProps extends LinkProps {
    /** the status of the upload */
    status: "completed" | "previously";
    /** the URL opened by the file link. Must be provided for only the `completed` and `previously` statuses. */
    href: string;
}
interface StatusErrorProps {
    /** the status of the upload */
    status: "error";
}
interface MandatoryStatusProps {
    /** the name of the file */
    filename: string;
    /** a function to be executed when the user clicks the appropriate action button (Clear/Delete File/Cancel Upload)  */
    onAction: () => void;
    /** The status message. Used to display the current upload progress, including error messages where appropriate. Not used for the `previously` status. */
    message?: string;
    /** The icon to use for the file during or after upload */
    iconType?: IconType;
}
export declare type FileUploadStatusProps = MandatoryStatusProps & (StatusUploadingProps | StatusErrorProps | StatusDoneProps);
export declare const FileUploadStatus: ({ status, filename, message, onAction, iconType, ...statusProps }: FileUploadStatusProps) => React.JSX.Element;
export default FileUploadStatus;
