function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState, useEffect } from "react";
import PropTypes from "prop-types";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import { FieldsetStyle, StyledLegend } from "./fieldset.style";
import { NewValidationContext } from "../carbon-provider/carbon-provider.component";
import FormSpacingProvider from "../../__internal__/form-spacing-provider";
import useFormSpacing from "../../hooks/__internal__/useFormSpacing";
export const Fieldset = ({
  children,
  legend,
  required,
  isOptional,
  ...rest
}) => {
  const [ref, setRef] = useState(null);
  const marginProps = useFormSpacing(rest);
  useEffect(() => {
    if (ref && required) {
      Array.from(ref.querySelectorAll("input") || /* istanbul ignore next */[]).forEach(el => {
        el.setAttribute("required", "");
      });
    }
  }, [ref, required]);
  return /*#__PURE__*/React.createElement(NewValidationContext.Provider, {
    value: {
      validationRedesignOptIn: false
    }
  }, /*#__PURE__*/React.createElement(FieldsetStyle, _extends({
    ref: setRef
  }, tagComponent("fieldset", rest), rest, marginProps), legend && /*#__PURE__*/React.createElement(StyledLegend, {
    "data-element": "legend",
    isRequired: required,
    isOptional: isOptional
  }, legend), /*#__PURE__*/React.createElement(FormSpacingProvider, {
    marginBottom: undefined
  }, children)));
};
Fieldset.displayName = "Fieldset";
export default Fieldset;