import React, { useCallback, useContext, useEffect, useMemo } from "react";
import PropTypes from "prop-types";
import { TransitionGroup } from "react-transition-group";
import { StyledPicklist, StyledEmptyContainer } from "./picklist.style";
import FocusContext from "../duelling-picklist.context";
import Events from "../../../__internal__/utils/helpers/events";
import PicklistGroup from "../picklist-group/picklist-group.component";
export const Picklist = ({
  disabled,
  children,
  placeholder,
  index
}) => {
  const {
    elementToFocus,
    setElementToFocus
  } = useContext(FocusContext);
  const isEmpty = useMemo(() => !React.Children.toArray(children).length, [children]);
  const filteredChildren = React.Children.toArray(children);
  const refs = useMemo(() => Array.from({
    length: filteredChildren.length
  }, () => /*#__PURE__*/React.createRef()), [filteredChildren.length]);
  const focusItem = useCallback((ev, itemIndex) => {
    ev.preventDefault();
    refs[itemIndex].current?.focus();
  }, [refs]);
  const handleKeyDown = useCallback(ev => {
    if (Events.isHomeKey(ev)) {
      focusItem(ev, 0);
    } else if (Events.isEndKey(ev)) {
      focusItem(ev, refs.length - 1);
    }
  }, [focusItem, refs]);
  const content = filteredChildren.map((child, childIndex) => {
    if (! /*#__PURE__*/React.isValidElement(child)) {
      return child;
    }
    const props = {
      ref: refs[childIndex],
      disabled,
      index: childIndex,
      listIndex: index,
      isLastGroup: child.type === PicklistGroup && childIndex === filteredChildren.length - 1
    };
    return /*#__PURE__*/React.cloneElement(child, props);
  });
  useEffect(() => {
    if (elementToFocus.groupIndex === undefined && elementToFocus.listIndex === index && elementToFocus.itemIndex !== undefined) {
      const itemToBeFocused = refs[elementToFocus.itemIndex]?.current;
      if (itemToBeFocused) {
        itemToBeFocused.focus();
        setElementToFocus();
      } else {
        setElementToFocus(0, index === 0 ? 1 : 0, elementToFocus.groupIndex);
      }
    }
  }, [elementToFocus, index, refs, setElementToFocus]);
  return /*#__PURE__*/React.createElement(StyledPicklist, {
    "data-element": "picklist",
    scrollVariant: "light",
    onKeyDown: handleKeyDown
  }, isEmpty && /*#__PURE__*/React.createElement(StyledEmptyContainer, null, placeholder), /*#__PURE__*/React.createElement(TransitionGroup, {
    component: null
  }, content));
};
Picklist.displayName = "Picklist";
export default Picklist;