function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useContext, useRef } from "react";
import PropTypes from "prop-types";
import { CSSTransition } from "react-transition-group";
import { StyledPicklistItem, StyledButton, StyledLockIcon } from "./picklist-item.style";
import FocusContext from "../duelling-picklist.context";
import Events from "../../../__internal__/utils/helpers/events";
const PicklistItem = /*#__PURE__*/React.forwardRef(({
  children,
  type,
  onChange,
  item,
  locked,
  tooltipMessage = "This item is locked and can not be moved",
  index,
  listIndex,
  groupIndex,
  isLastGroup,
  isLastItem,
  ...transitionGroupProps
}, ref) => {
  const {
    setElementToFocus
  } = useContext(FocusContext);
  const picklistItemNodeRef = useRef(null);
  const calculateFocusIndex = useCallback(() => {
    if (isLastItem) {
      const toggledListIndex = listIndex === 0 ? 1 : 0;
      const incrementedGroupIndex = groupIndex === 0 && index !== 0 ? 1 : groupIndex;
      return {
        itemIndex: isLastGroup ? 0 : incrementedGroupIndex,
        list: isLastGroup ? toggledListIndex : listIndex,
        group: undefined
      };
    }
    return {
      itemIndex: index,
      list: listIndex,
      group: groupIndex
    };
  }, [groupIndex, index, isLastGroup, isLastItem, listIndex]);
  const updateFocusElement = useCallback(() => {
    const {
      itemIndex,
      list,
      group
    } = calculateFocusIndex();
    setElementToFocus(itemIndex, list, group);
  }, [calculateFocusIndex, setElementToFocus]);
  const handleClick = useCallback(() => {
    onChange(item);
    updateFocusElement();
  }, [onChange, item, updateFocusElement]);
  const handleKeydown = useCallback(event => {
    if (Events.isEnterKey(event) || Events.isSpaceKey(event)) {
      event.preventDefault();
      onChange(item);
      updateFocusElement();
    }
  }, [onChange, item, updateFocusElement]);
  return /*#__PURE__*/React.createElement(CSSTransition, _extends({
    timeout: {
      appear: 500,
      enter: 300,
      exit: 0
    },
    classNames: "picklist-item"
  }, transitionGroupProps, type === "add" ? {
    enter: false
  } : {}, {
    nodeRef: picklistItemNodeRef
  }), /*#__PURE__*/React.createElement(StyledPicklistItem, {
    onKeyDown: handleKeydown,
    "data-element": "picklist-item",
    locked: locked,
    ref: picklistItemNodeRef
  }, children, !locked && /*#__PURE__*/React.createElement(StyledButton, {
    buttonType: "primary",
    destructive: type === "remove",
    iconType: type,
    onClick: handleClick,
    ref: ref
  }), locked && /*#__PURE__*/React.createElement(StyledLockIcon, {
    type: "locked",
    tooltipMessage: tooltipMessage
  })));
});
if (process.env.NODE_ENV !== "production") {
  PicklistItem.propTypes = {
    "children": PropTypes.node,
    "groupIndex": PropTypes.number,
    "index": PropTypes.number,
    "isLastGroup": PropTypes.bool,
    "isLastItem": PropTypes.bool,
    "item": PropTypes.oneOfType([PropTypes.number, PropTypes.object, PropTypes.string]).isRequired,
    "listIndex": PropTypes.number,
    "locked": PropTypes.bool,
    "onChange": PropTypes.func.isRequired,
    "tooltipMessage": PropTypes.string,
    "type": PropTypes.oneOf(["add", "remove"]).isRequired
  };
}
export { PicklistItem };
PicklistItem.displayName = "PicklistItem";
export default PicklistItem;