import React from "react";
declare type Item = Record<string, unknown> | string | number;
export interface PicklistItemProps {
    /** Item content */
    children: React.ReactNode;
    /** Define if item is of type add or remove */
    type: "add" | "remove";
    /** Handler invoked when add/remove button is clicked or when space/enter is pressed on the whole item */
    onChange: (item: Item) => void;
    /** Value passed to the onChange handler - can be a string, a number or an object */
    item: Item;
    /** Disable the item */
    locked?: boolean;
    /** Tooltip message for the locked icon (only present when locked prop is true) */
    tooltipMessage?: string;
    /** @private @ignore */
    index?: number;
    /** @private @ignore */
    groupIndex?: number;
    /** @private @ignore */
    listIndex?: number;
    /** @private @ignore */
    isLastItem?: boolean;
    /** @private @ignore */
    isLastGroup?: boolean;
}
export declare const PicklistItem: React.ForwardRefExoticComponent<PicklistItemProps & React.RefAttributes<HTMLButtonElement>>;
export default PicklistItem;
