function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useContext, useEffect, useMemo, useState } from "react";
import PropTypes from "prop-types";
import { CSSTransition, TransitionGroup } from "react-transition-group";
import { StyledGroupWrapper, StyledPicklistGroupUl, StyledPicklistGroup, StyledGroupButton } from "./picklist-group.style";
import FocusContext from "../duelling-picklist.context";
import Events from "../../../__internal__/utils/helpers/events";
const PicklistGroup = /*#__PURE__*/React.forwardRef(({
  title,
  children,
  type,
  onChange,
  index,
  listIndex,
  isLastGroup,
  ...transitionGroupProps
}, ref) => {
  const {
    setElementToFocus,
    elementToFocus
  } = useContext(FocusContext);
  const [highlighted, setHighlighted] = useState(false);
  const filteredChildren = React.Children.toArray(children);
  const handleClick = useCallback(() => {
    onChange();
    setElementToFocus(index, listIndex);
  }, [index, listIndex, onChange, setElementToFocus]);
  const handleKeydown = useCallback(event => {
    if (Events.isEnterKey(event) || Events.isSpaceKey(event)) {
      event.preventDefault();
      onChange();
      setElementToFocus(index, listIndex);
    }
  }, [index, listIndex, onChange, setElementToFocus]);
  const refs = useMemo(() => Array.from({
    length: filteredChildren.length
  }, () => /*#__PURE__*/React.createRef()), [filteredChildren.length]);
  const content = React.Children.map(children, (child, childIndex) => {
    if (! /*#__PURE__*/React.isValidElement(child)) {
      return child;
    }
    const props = {
      ref: refs[childIndex],
      index: childIndex,
      listIndex,
      groupIndex: index,
      isLastGroup,
      isLastItem: childIndex === filteredChildren.length - 1
    };
    return /*#__PURE__*/React.cloneElement(child, props);
  });
  useEffect(() => {
    if (elementToFocus.groupIndex === index && elementToFocus.listIndex === listIndex && elementToFocus.itemIndex !== undefined) {
      refs[elementToFocus.itemIndex].current?.focus();
      setElementToFocus();
    }
  }, [elementToFocus, index, isLastGroup, listIndex, refs, setElementToFocus]);
  return /*#__PURE__*/React.createElement(CSSTransition, _extends({
    timeout: {
      appear: 500,
      enter: 300,
      exit: 0
    },
    classNames: "picklist-group"
  }, transitionGroupProps, type === "add" ? {
    enter: false
  } : {}), /*#__PURE__*/React.createElement(StyledGroupWrapper, {
    highlighted: highlighted,
    type: type
  }, /*#__PURE__*/React.createElement(StyledPicklistGroupUl, null, /*#__PURE__*/React.createElement(StyledPicklistGroup, {
    onKeyDown: handleKeydown,
    "data-element": "picklist-group"
  }, title, /*#__PURE__*/React.createElement(StyledGroupButton, {
    buttonType: "secondary",
    destructive: type === "remove",
    iconType: type,
    onClick: handleClick,
    onMouseEnter: () => setHighlighted(true),
    onMouseLeave: () => setHighlighted(false),
    onFocus: () => setHighlighted(true),
    onBlur: () => setHighlighted(false),
    ref: ref
  })), /*#__PURE__*/React.createElement(TransitionGroup, {
    component: null
  }, content))));
});
if (process.env.NODE_ENV !== "production") {
  PicklistGroup.propTypes = {
    "children": PropTypes.node,
    "index": PropTypes.number,
    "isLastGroup": PropTypes.bool,
    "listIndex": PropTypes.number,
    "onChange": PropTypes.func.isRequired,
    "title": PropTypes.node,
    "type": PropTypes.oneOf(["add", "remove"]).isRequired
  };
}
export { PicklistGroup };
PicklistGroup.displayName = "PicklistGroup";
export default PicklistGroup;