import React from "react";
export interface PicklistGroupProps {
    /** Group title */
    title: React.ReactNode;
    /** Item content */
    children: React.ReactNode;
    /** Define if item is of type add or remove */
    type: "add" | "remove";
    /** Handler invoked when add/remove button is clicked or when space/enter is pressed on the whole item */
    onChange: () => void;
    /** @private @ignore */
    index?: number;
    /** @private @ignore */
    listIndex?: number;
    /** @private @ignore */
    isLastGroup?: boolean;
}
export declare const PicklistGroup: React.ForwardRefExoticComponent<PicklistGroupProps & React.RefAttributes<HTMLButtonElement>>;
export default PicklistGroup;
