function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState } from "react";
import PropTypes from "prop-types";
import { filterStyledSystemMarginProps } from "../../style/utils";
import { StyledDuellingPicklistOverlay, StyledDuellingPicklist, StyledLabelContainer, StyledLabel, StyledControlsContainer, StyledControl } from "./duelling-picklist.style";
import { Picklist } from "./picklist/picklist.component";
import FocusContext from "./duelling-picklist.context";
export const DuellingPicklist = ({
  children,
  disabled,
  leftControls,
  rightControls,
  leftLabel,
  rightLabel,
  ...rest
}) => {
  const shouldDisplayLabels = leftLabel || rightLabel;
  const shouldDisplayControls = leftControls || rightControls;
  const [elementToFocus, setElementToFocus] = useState({});
  let pickListIndex = 0;
  const addElementToFocus = (itemIndex, listIndex, groupIndex) => {
    setElementToFocus({
      itemIndex,
      listIndex,
      groupIndex
    });
  };
  const getIndex = () => {
    const index = pickListIndex;
    pickListIndex += 1;
    return index;
  };
  const clonedChildren = React.Children.map(children, child => {
    if ( /*#__PURE__*/React.isValidElement(child) && child.type === Picklist) {
      return /*#__PURE__*/React.cloneElement(child, {
        index: getIndex()
      });
    }
    return child;
  });
  return /*#__PURE__*/React.createElement(StyledDuellingPicklistOverlay, _extends({
    disabled: disabled,
    "data-component": "duelling-picklist"
  }, filterStyledSystemMarginProps(rest)), shouldDisplayLabels && /*#__PURE__*/React.createElement(StyledLabelContainer, null, /*#__PURE__*/React.createElement(StyledLabel, {
    "data-element": "picklist-left-label"
  }, leftLabel), /*#__PURE__*/React.createElement(StyledLabel, {
    "data-element": "picklist-right-label"
  }, rightLabel)), shouldDisplayControls && /*#__PURE__*/React.createElement(StyledControlsContainer, null, /*#__PURE__*/React.createElement(StyledControl, {
    "data-element": "picklist-left-control"
  }, leftControls), /*#__PURE__*/React.createElement(StyledControl, {
    "data-element": "picklist-right-label"
  }, rightControls)), /*#__PURE__*/React.createElement(FocusContext.Provider, {
    value: {
      setElementToFocus: addElementToFocus,
      elementToFocus
    }
  }, /*#__PURE__*/React.createElement(StyledDuellingPicklist, null, clonedChildren)));
};
export default DuellingPicklist;