function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState, useCallback, useRef, useEffect } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import createGuid from "../../__internal__/utils/helpers/guid";
import usePrevious from "../../hooks/__internal__/usePrevious";
import Icon from "../icon";
import { StyledSidebarHeader, StyledDrawerWrapper, StyledDrawerContent, StyledSidebarToggleButton, StyledDrawerChildren, StyledDrawerSidebar, StyledSidebarTitle } from "./drawer.style";
import StickyFooter from "../../__internal__/sticky-footer";
const DrawerSidebarContext = /*#__PURE__*/React.createContext({});
export const Drawer = ({
  defaultExpanded = true,
  expanded,
  onChange,
  children,
  expandedWidth = "40%",
  sidebar,
  animationDuration = "400ms",
  backgroundColor,
  title,
  footer,
  showControls,
  height = "100%",
  stickyHeader,
  stickyFooter,
  ...rest
}) => {
  const drawerSidebarContentRef = useRef(null);
  const scrollableContentRef = useRef(null);
  const isControlled = useRef(expanded !== undefined);
  const [isOpening, setIsOpening] = useState(false);
  const [isClosing, setIsClosing] = useState(false);
  const [isExpanded, setIsExpanded] = useState(isControlled.current ? expanded : defaultExpanded);
  const timer = useRef(null);
  const getAnimationDuration = useCallback(() => {
    if (animationDuration.indexOf("ms") !== -1) {
      const animationTime = animationDuration.substring(0, animationDuration.length - 2);
      return parseInt(animationTime);
    }
    if (animationDuration.indexOf(".") !== -1 || animationDuration.indexOf("s") !== -1) {
      const animationTime = animationDuration.substring(0, animationDuration.length - 1);
      return parseFloat(animationTime) * 1000;
    }
    return parseInt(animationDuration);
  }, [animationDuration]);
  const toggleAnimation = useCallback(() => {
    const timeout = getAnimationDuration();
    if (timer.current) {
      clearTimeout(timer.current);
    }
    if (!isExpanded) {
      setIsClosing(false);
      setIsOpening(true);
      timer.current = setTimeout(() => {
        setIsOpening(false);
      }, timeout);
    } else {
      setIsOpening(false);
      setIsClosing(true);
      timer.current = setTimeout(() => {
        setIsClosing(false);
      }, timeout);
    }
  }, [getAnimationDuration, isExpanded]);
  const previousValue = usePrevious(expanded);
  useEffect(() => {
    const message = "Drawer should not switch from uncontrolled to controlled" + " (or vice versa). Decide between using a controlled or uncontrolled Drawer element" + " for the lifetime of the component";
    !(isControlled.current === (expanded !== undefined)) ? process.env.NODE_ENV !== "production" ? invariant(false, message) : invariant(false) : void 0;
    if (isControlled.current && previousValue !== expanded) {
      setIsExpanded(expanded);
      if (!showControls && ![expanded, previousValue].includes(undefined)) {
        toggleAnimation();
      }
    }
  }, [expanded, toggleAnimation, previousValue, showControls]);
  useEffect(() => {
    return function cleanup() {
      if (timer.current) {
        clearTimeout(timer.current);
      }
    };
  }, []);
  const toggleDrawer = useCallback(ev => {
    setIsExpanded(!isExpanded);
    if (onChange) onChange(ev, !isExpanded);
    if (isExpanded && drawerSidebarContentRef.current) {
      drawerSidebarContentRef.current.scrollTop = 0;
    }
    toggleAnimation();
  }, [toggleAnimation, isExpanded, onChange]);
  const guid = useRef(createGuid());
  const sidebarId = `DrawerSidebar_${guid.current}`;
  const getClassNames = useCallback(() => {
    const classes = [isExpanded ? "open" : "closed"];
    if (isOpening) {
      classes.push("opening");
    }
    if (isClosing) {
      classes.push("closing");
    }
    return classes.join(" ");
  }, [isExpanded, isOpening, isClosing]);
  const getControls = () => {
    if (showControls === undefined) return null;
    return /*#__PURE__*/React.createElement(StyledSidebarToggleButton, {
      "aria-label": "toggle sidebar",
      "aria-expanded": isExpanded,
      "aria-controls": sidebarId,
      "data-element": "drawer-toggle",
      onClick: toggleDrawer,
      isExpanded: isExpanded,
      animationDuration: animationDuration
    }, /*#__PURE__*/React.createElement(Icon, {
      type: "chevron_right"
    }));
  };
  return /*#__PURE__*/React.createElement(StyledDrawerWrapper, _extends({
    "data-component": "drawer",
    height: height
  }, rest), /*#__PURE__*/React.createElement(StyledDrawerContent, {
    expandedWidth: expandedWidth,
    animationDuration: animationDuration,
    className: getClassNames(),
    ref: drawerSidebarContentRef,
    backgroundColor: backgroundColor,
    "data-element": "drawer-content"
  }, stickyHeader && /*#__PURE__*/React.createElement(StyledSidebarHeader, {
    isExpanded: isExpanded
  }, title && /*#__PURE__*/React.createElement(StyledSidebarTitle, null, title), getControls()), !stickyHeader && /*#__PURE__*/React.createElement(React.Fragment, null, title && /*#__PURE__*/React.createElement(StyledSidebarTitle, null, title), getControls()), /*#__PURE__*/React.createElement(StyledDrawerSidebar, {
    hasControls: !!showControls,
    id: sidebarId,
    isExpanded: isExpanded,
    role: "navigation",
    overflowY: isExpanded ? "auto" : undefined,
    scrollVariant: "light",
    ref: scrollableContentRef
  }, /*#__PURE__*/React.createElement(DrawerSidebarContext.Provider, {
    value: {
      isInSidebar: true
    }
  }, sidebar), footer && /*#__PURE__*/React.createElement(StickyFooter, {
    containerRef: scrollableContentRef,
    disableSticky: !stickyFooter
  }, footer))), /*#__PURE__*/React.createElement(StyledDrawerChildren, null, children));
};
export { DrawerSidebarContext };
export default Drawer;