import React from "react";
export interface DrawerSidebarContextProps {
    isInSidebar: boolean;
}
export interface DrawerProps {
    /** Duration of a animation */
    animationDuration?: string;
    /** Specify an aria-label for the Drawer component */
    "aria-label"?: string;
    /** Sets color of sidebar's background */
    backgroundColor?: string;
    children: React.ReactNode;
    /** Set the default state of expansion of the Drawer if component is meant to be used as uncontrolled */
    defaultExpanded?: boolean;
    /** Sets the expansion state of the Drawer if component is meant to be used as controlled */
    expanded?: boolean;
    expandedWidth?: string;
    /** Sets custom height to Drawer component */
    height?: string;
    /** Callback fired when expansion state changes, onChange(event: object, isExpanded: boolean) */
    onChange?: (e: React.MouseEvent<HTMLElement> | React.KeyboardEvent<HTMLElement>, isExpanded: boolean) => void;
    sidebar?: React.ReactNode;
    /** Enables expand/collapse button that controls drawer */
    showControls?: boolean;
    /** Sets the heading of the drawer */
    title?: React.ReactNode;
    /** Content to display inside of a footer */
    footer?: React.ReactNode;
    /** Makes the header of the drawer sticky. Title prop must also be set. */
    stickyHeader?: boolean;
    /** Makes the footer of the drawer sticky. Footer prop must also be set. */
    stickyFooter?: boolean;
}
declare const DrawerSidebarContext: React.Context<Partial<DrawerSidebarContextProps>>;
export declare const Drawer: ({ defaultExpanded, expanded, onChange, children, expandedWidth, sidebar, animationDuration, backgroundColor, title, footer, showControls, height, stickyHeader, stickyFooter, ...rest }: DrawerProps) => React.JSX.Element;
export { DrawerSidebarContext };
export default Drawer;
