import React from "react";
import { PaddingProps } from "styled-system";
export interface DraggableItemProps extends PaddingProps {
    /**
     * The id of the `DraggableItem`.
     *
     * Use this prop to make `Draggable` work
     */
    id: number | string;
    /** The content of the component. */
    children: React.ReactNode;
    /**
     * @private
     * @ignore
     */
    findItem?: (id: string | number) => {
        DraggableItemProps: React.ReactElement;
        index: number;
    };
    /**
     * @private
     * @ignore
     */
    moveItem?: (droppedId: string | number, overIndex: number | undefined) => void;
}
declare const DraggableItem: {
    ({ id, findItem, moveItem, children, py, ...rest }: DraggableItemProps): JSX.Element;
    displayName: string;
};
export default DraggableItem;
