import React from "react";
import { MarginProps } from "styled-system";
export interface DraggableContainerProps extends MarginProps {
    /** Callback fired when order is changed */
    getOrder?: (draggableItemIds?: (string | number | undefined)[], movedItemId?: string | number | undefined) => void;
    /**
     * The content of the component
     *
     * `<DraggableItem />` is required to make `Draggable` works
     */
    children?: React.ReactNode;
}
declare const DraggableContainer: {
    ({ children, getOrder, ...rest }: DraggableContainerProps): JSX.Element;
    displayName: string;
};
export default DraggableContainer;
