function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import { useDrop } from "react-dnd";
import { StyledDraggableContainer } from "../draggable-item/draggable-item.style";
const DropTarget = ({
  children,
  getOrder,
  ...rest
}) => {
  const [, drop] = useDrop({
    accept: "draggableItem",
    drop(item) {
      // istanbul ignore else
      if (getOrder) {
        getOrder(item?.id);
      }
    }
  });
  return /*#__PURE__*/React.createElement(StyledDraggableContainer, _extends({
    ref: drop
  }, rest), children);
};
export default DropTarget;