function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import useLocale from "../../hooks/__internal__/useLocale";
import { StyledDismissibleBox } from "./dismissible-box.style";
import IconButton from "../icon-button";
import Icon from "../icon";
import tagComponent from "../../__internal__/utils/helpers/tags";
export const DismissibleBox = ({
  children,
  closeButtonDataProps,
  onClose,
  borderRadius = "borderRadius100",
  ...rest
}) => {
  const locale = useLocale();
  return /*#__PURE__*/React.createElement(StyledDismissibleBox, _extends({
    p: "20px 24px 20px 20px",
    "data-component": "dismissible-box",
    borderRadius: borderRadius
  }, rest), children, /*#__PURE__*/React.createElement("span", {
    "data-element": "close-button-wrapper"
  }, /*#__PURE__*/React.createElement(IconButton, _extends({
    onClick: onClose,
    "aria-label": locale.dismissibleBox.ariaLabels.close(),
    ml: 3
  }, tagComponent("close-button", {
    "data-element": "close-button",
    ...closeButtonDataProps
  })), /*#__PURE__*/React.createElement(Icon, {
    type: "close",
    color: "--colorsActionMinor500"
  }))));
};
export default DismissibleBox;