import React from "react";
import { SpaceProps } from "styled-system";
import { StyledDismissibleBoxProps } from "./dismissible-box.style";
import { BoxProps } from "../box";
import { TagProps } from "../../__internal__/utils/helpers/tags";
export interface DismissibleBoxProps extends SpaceProps, StyledDismissibleBoxProps, Omit<BoxProps, "display" | "justifyContent">, Omit<TagProps, "data-component"> {
    /** The content to render in the component */
    children?: React.ReactNode;
    /** Data tag prop bag for close Button */
    closeButtonDataProps?: TagProps;
    /** Callback to be called when the close icon button is clicked */
    onClose: (e: React.KeyboardEvent<HTMLButtonElement> | React.MouseEvent<HTMLButtonElement>) => void;
    /** Use this prop to override the default width. Numbers from 0-1 are converted to percentage widths. Numbers greater
     * than 1 are converted to pixel values. String values are passed as raw CSS values. And arrays are converted to
     * responsive width styles. If theme.sizes is defined, the width prop will attempt to pick up values from the theme.
     * Please note this component has a minWidth of 600px */
    width?: number | string;
}
export declare const DismissibleBox: ({ children, closeButtonDataProps, onClose, borderRadius, ...rest }: DismissibleBoxProps) => React.JSX.Element;
export default DismissibleBox;
