function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef, useEffect, useLayoutEffect, useCallback, useImperativeHandle, forwardRef } from "react";
import PropTypes from "prop-types";
import createGuid from "../../__internal__/utils/helpers/guid";
import Modal from "../modal";
import Heading from "../heading";
import tagComponent from "../../__internal__/utils/helpers/tags";
import useResizeObserver from "../../hooks/__internal__/useResizeObserver";
import { StyledDialog, StyledDialogTitle, StyledDialogContent, StyledDialogInnerContent } from "./dialog.style";
import { TOP_MARGIN } from "./dialog.config";
import FocusTrap from "../../__internal__/focus-trap";
import IconButton from "../icon-button";
import Icon from "../icon";
import useLocale from "../../hooks/__internal__/useLocale";
import useIsStickyFooterForm from "../../hooks/__internal__/useIsStickyFooterForm";
import useModalAria from "../../hooks/__internal__/useModalAria/useModalAria";
const PADDING_VALUES = [0, 1, 2, 3, 4, 5, 6, 7, 8];
const Dialog = /*#__PURE__*/forwardRef(({
  className,
  children,
  open,
  height,
  size = "medium",
  title,
  disableEscKey,
  subtitle,
  disableAutoFocus = false,
  focusFirstElement,
  focusableSelectors,
  onCancel,
  showCloseIcon = true,
  bespokeFocusTrap,
  disableClose,
  help,
  role = "dialog",
  contentPadding = {},
  greyBackground = false,
  focusableContainers,
  topModalOverride,
  closeButtonDataProps,
  ...rest
}, ref) => {
  const locale = useLocale();
  const containerRef = useRef(null);
  const innerContentRef = useRef(null);
  const titleRef = useRef(null);
  const listenersAdded = useRef(false);
  const {
    current: titleId
  } = useRef(createGuid());
  const {
    current: subtitleId
  } = useRef(createGuid());
  const hasStickyFooter = useIsStickyFooterForm(children);
  const isTopModal = useModalAria(containerRef);
  useImperativeHandle(ref, () => ({
    focus() {
      containerRef.current?.focus();
    }
  }), []);
  const centerDialog = useCallback(() => {
    /* istanbul ignore if */
    if (!containerRef.current) {
      return;
    }
    const {
      width: dialogWidth,
      height: dialogHeight
    } = containerRef.current.getBoundingClientRect();
    let midPointY = window.innerHeight / 2;
    let midPointX = window.innerWidth / 2;
    midPointY -= dialogHeight / 2;
    midPointX -= dialogWidth / 2;
    if (midPointY < TOP_MARGIN) {
      midPointY = TOP_MARGIN;
    }
    if (midPointX < 0) {
      midPointX = 0;
    }
    containerRef.current.style.top = `${midPointY}px`;
    containerRef.current.style.left = `${midPointX}px`;
  }, []);
  useResizeObserver(innerContentRef, centerDialog, !open);
  const addListeners = useCallback(() => {
    /* istanbul ignore else */
    if (!listenersAdded.current) {
      window.addEventListener("resize", centerDialog);
      listenersAdded.current = true;
    }
  }, [centerDialog]);
  const removeListeners = useCallback(() => {
    if (listenersAdded.current) {
      window.removeEventListener("resize", centerDialog);
      listenersAdded.current = false;
    }
  }, [centerDialog]);
  useEffect(() => {
    if (open) {
      addListeners();
    }
    if (!open) {
      removeListeners();
    }
    return () => {
      removeListeners();
    };
  }, [open, addListeners, removeListeners]);
  useLayoutEffect(() => {
    if (open) {
      centerDialog();
    }
  }, [centerDialog, open, height]);
  const closeIcon = () => {
    if (!showCloseIcon || !onCancel) return null;
    return /*#__PURE__*/React.createElement(IconButton, _extends({
      "aria-label": locale.dialog.ariaLabels.close(),
      onClick: onCancel,
      disabled: disableClose
    }, tagComponent("close", {
      "data-element": "close",
      ...closeButtonDataProps
    })), /*#__PURE__*/React.createElement(Icon, {
      type: "close"
    }));
  };
  const dialogTitle = () => {
    if (!title) return null;
    return /*#__PURE__*/React.createElement(StyledDialogTitle, {
      showCloseIcon: showCloseIcon,
      hasSubtitle: !!subtitle,
      ref: titleRef
    }, typeof title === "string" ? /*#__PURE__*/React.createElement(Heading, {
      "data-element": "dialog-title",
      title: title,
      titleId: titleId,
      subheader: subtitle,
      subtitleId: subtitleId,
      divider: false,
      help: help
    }) : title);
  };
  let dialogHeight = height;
  if (height && height.match(/px$/)) {
    dialogHeight = height.replace("px", "");
  }
  const dialogProps = {
    size,
    dialogHeight,
    "aria-labelledby": title && typeof title === "string" ? titleId : rest["aria-labelledby"],
    "aria-describedby": subtitle && typeof subtitle === "string" ? subtitleId : rest["aria-describedby"],
    "aria-label": rest["aria-label"]
  };
  const componentTags = {
    "data-component": rest["data-component"] || "dialog",
    "data-element": rest["data-element"],
    "data-role": rest["data-role"]
  };
  return /*#__PURE__*/React.createElement(Modal, _extends({
    open: open,
    onCancel: onCancel,
    disableEscKey: disableEscKey,
    disableClose: disableClose,
    className: className ? `${className} carbon-dialog` : "carbon-dialog",
    topModalOverride: topModalOverride
  }, componentTags), /*#__PURE__*/React.createElement(FocusTrap, {
    autoFocus: !disableAutoFocus,
    focusFirstElement: focusFirstElement,
    bespokeTrap: bespokeFocusTrap,
    focusableSelectors: focusableSelectors,
    wrapperRef: containerRef,
    isOpen: open,
    additionalWrapperRefs: focusableContainers
  }, /*#__PURE__*/React.createElement(StyledDialog, _extends({
    "aria-modal": isTopModal ? true : undefined,
    ref: containerRef,
    topMargin: TOP_MARGIN
  }, dialogProps, {
    "data-component": "dialog",
    "data-element": "dialog",
    "data-role": rest["data-role"],
    role: role,
    tabIndex: -1
  }, contentPadding, {
    backgroundColor: greyBackground ? "var(--colorsUtilityMajor025)" : "var(--colorsUtilityYang100)"
  }), dialogTitle(), closeIcon(), /*#__PURE__*/React.createElement(StyledDialogContent, _extends({}, contentPadding, {
    hasStickyFooter: hasStickyFooter
  }), /*#__PURE__*/React.createElement(StyledDialogInnerContent, _extends({
    ref: innerContentRef
  }, contentPadding), children)))));
});
if (process.env.NODE_ENV !== "production") {
  Dialog.propTypes = {
    "aria-describedby": PropTypes.string,
    "aria-label": PropTypes.string,
    "aria-labelledby": PropTypes.string,
    "ariaRole": PropTypes.string,
    "bespokeFocusTrap": PropTypes.func,
    "children": PropTypes.node,
    "className": PropTypes.string,
    "closeButtonDataProps": PropTypes.shape({
      "data-element": PropTypes.string,
      "data-role": PropTypes.string
    }),
    "contentPadding": PropTypes.shape({
      "p": PropTypes.oneOf([0, 1, 2, 3, 4, 5, 6, 7, 8]),
      "px": PropTypes.oneOf([0, 1, 2, 3, 4, 5, 6, 7, 8]),
      "py": PropTypes.oneOf([0, 1, 2, 3, 4, 5, 6, 7, 8])
    }),
    "data-component": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "disableAutoFocus": PropTypes.bool,
    "disableClose": PropTypes.bool,
    "disableEscKey": PropTypes.bool,
    "disableFocusTrap": PropTypes.bool,
    "enableBackgroundUI": PropTypes.bool,
    "focusableContainers": PropTypes.arrayOf(PropTypes.shape({
      "current": function (props, propName) {
        if (props[propName] == null) {
          return null;
        } else if (typeof props[propName] !== 'object' || props[propName].nodeType !== 1) {
          return new Error("Expected prop '" + propName + "' to be of type Element");
        }
      }
    })),
    "focusableSelectors": PropTypes.string,
    "focusFirstElement": PropTypes.oneOfType([function (props, propName) {
      if (props[propName] == null) {
        return new Error("Prop '" + propName + "' is required but wasn't specified");
      } else if (typeof props[propName] !== 'object' || props[propName].nodeType !== 1) {
        return new Error("Expected prop '" + propName + "' to be of type Element");
      }
    }, PropTypes.shape({
      "current": function (props, propName) {
        if (props[propName] == null) {
          return null;
        } else if (typeof props[propName] !== 'object' || props[propName].nodeType !== 1) {
          return new Error("Expected prop '" + propName + "' to be of type Element");
        }
      }
    })]),
    "greyBackground": PropTypes.bool,
    "height": PropTypes.string,
    "help": PropTypes.string,
    "onCancel": PropTypes.func,
    "open": PropTypes.bool.isRequired,
    "role": PropTypes.string,
    "showCloseIcon": PropTypes.bool,
    "size": PropTypes.oneOf(["auto", "extra-large", "extra-small", "large", "medium-large", "medium-small", "medium", "small"]),
    "subtitle": PropTypes.node,
    "timeout": PropTypes.number,
    "title": PropTypes.node,
    "topModalOverride": PropTypes.bool
  };
}
export { Dialog };
export default Dialog;