import React from "react";
import { ModalProps } from "../modal";
import { TagProps } from "../../__internal__/utils/helpers/tags";
import { DialogSizes } from "./dialog.config";
import { CustomRefObject } from "../../__internal__/focus-trap";
declare const PADDING_VALUES: readonly [0, 1, 2, 3, 4, 5, 6, 7, 8];
declare type PaddingValues = typeof PADDING_VALUES[number];
export interface ContentPaddingInterface {
    p?: PaddingValues;
    py?: PaddingValues;
    px?: PaddingValues;
}
export interface DialogProps extends ModalProps, TagProps {
    /** Custom class name  */
    className?: string;
    /** Prop to specify the aria-describedby property of the Dialog component */
    "aria-describedby"?: string;
    /**
     * Prop to specify the aria-label of the Dialog component.
     * To be used only when the title prop is not defined, and the component is not labelled by any internal element.
     */
    "aria-label"?: string;
    /**
     * Prop to specify the aria-labelledby property of the Dialog component
     * To be used when the title prop is a custom React Node,
     * or the component is labelled by an internal element other than the title.
     */
    "aria-labelledby"?: string;
    disableAutoFocus?: boolean;
    disableFocusTrap?: boolean;
    /**
     * Function to replace focus trap
     * @ignore
     * @private
     */
    bespokeFocusTrap?: (ev: KeyboardEvent, firstElement?: HTMLElement, lastElement?: HTMLElement) => void;
    /** Optional reference to an element meant to be focused on open */
    focusFirstElement?: CustomRefObject<HTMLElement> | HTMLElement | null;
    /** Optional selector to identify the focusable elements, if not provided a default selector is used */
    focusableSelectors?: string;
    /** Allows developers to specify a specific height for the dialog. */
    height?: string;
    /** Adds Help tooltip to Header */
    help?: string;
    /** A custom close event handler */
    onCancel?: (ev: React.KeyboardEvent<HTMLElement> | React.MouseEvent<HTMLButtonElement>) => void;
    /** Determines if the close icon is shown */
    showCloseIcon?: boolean;
    /** Data tag prop bag for close Button */
    closeButtonDataProps?: Pick<TagProps, "data-role" | "data-element">;
    /** Size of dialog, default size is 750px */
    size?: DialogSizes;
    /** Subtitle displayed at top of dialog. Its consumers' responsibility to set a suitable accessible name/description for the Dialog if they pass a node to subtitle prop. */
    subtitle?: React.ReactNode;
    /** Title displayed at top of dialog. Its consumers' responsibility to set a suitable accessible name/description for the Dialog if they pass a node to title prop. */
    title?: React.ReactNode;
    /** The ARIA role to be applied to the Dialog container */
    role?: string;
    /** Padding to be set on the Dialog content */
    contentPadding?: ContentPaddingInterface;
    /** Change the background color of the content to grey */
    greyBackground?: boolean;
    /** an optional array of refs to containers whose content should also be reachable by tabbing from the dialog */
    focusableContainers?: CustomRefObject<HTMLElement>[];
}
export declare type DialogHandle = {
    /** Programmatically focus on root container of Dialog. */
    focus: () => void;
} | null;
export declare const Dialog: React.ForwardRefExoticComponent<DialogProps & React.RefAttributes<DialogHandle>>;
export default Dialog;
