function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef } from "react";
import PropTypes from "prop-types";
import createGuid from "../../__internal__/utils/helpers/guid";
import Modal from "../modal";
import Heading from "../heading";
import FullScreenHeading from "../../__internal__/full-screen-heading";
import StyledDialogFullScreen from "./dialog-full-screen.style";
import StyledContent from "./content.style";
import FocusTrap from "../../__internal__/focus-trap";
import IconButton from "../icon-button";
import Icon from "../icon";
import useLocale from "../../hooks/__internal__/useLocale";
import useIsStickyFooterForm from "../../hooks/__internal__/useIsStickyFooterForm";
import useModalAria from "../../hooks/__internal__/useModalAria/useModalAria";
import tagComponent from "../../__internal__/utils/helpers/tags";
export const DialogFullScreen = ({
  "aria-describedby": ariaDescribedBy,
  "aria-label": ariaLabel,
  "aria-labelledby": ariaLabelledBy,
  disableAutoFocus = false,
  focusFirstElement,
  bespokeFocusTrap,
  open,
  children,
  title,
  subtitle,
  pagesStyling,
  headerChildren,
  showCloseIcon = true,
  disableContentPadding,
  disableEscKey,
  onCancel,
  contentRef,
  help,
  role = "dialog",
  focusableContainers,
  focusableSelectors,
  topModalOverride,
  closeButtonDataProps,
  ...rest
}) => {
  const locale = useLocale();
  const dialogRef = useRef(null);
  const headingRef = useRef(null);
  const {
    current: titleId
  } = useRef(createGuid());
  const {
    current: subtitleId
  } = useRef(createGuid());
  const hasStickyFooter = useIsStickyFooterForm(children);
  const isTopModal = useModalAria(dialogRef);
  const closeIcon = () => {
    if (!showCloseIcon || !onCancel) return null;
    return /*#__PURE__*/React.createElement(IconButton, _extends({
      "aria-label": locale.dialogFullScreen.ariaLabels.close(),
      onClick: onCancel
    }, tagComponent("close", {
      "data-element": "close",
      ...closeButtonDataProps
    })), /*#__PURE__*/React.createElement(Icon, {
      type: "close"
    }));
  };
  const dialogTitle = () => /*#__PURE__*/React.createElement(FullScreenHeading, {
    hasContent: !!title,
    ref: headingRef
  }, typeof title === "string" ? /*#__PURE__*/React.createElement(Heading, {
    "data-element": "dialog-title",
    title: title,
    titleId: titleId,
    subheader: subtitle,
    subtitleId: subtitleId,
    divider: false,
    help: help
  }) : title, headerChildren);
  const ariaProps = {
    "aria-labelledby": title && typeof title === "string" ? titleId : ariaLabelledBy,
    "aria-describedby": subtitle && typeof subtitle === "string" ? subtitleId : ariaDescribedBy,
    "aria-label": ariaLabel
  };
  const componentTags = {
    "data-component": "dialog-full-screen",
    "data-element": rest["data-element"],
    "data-role": rest["data-role"]
  };
  return /*#__PURE__*/React.createElement(Modal, _extends({
    open: open,
    onCancel: onCancel,
    disableEscKey: disableEscKey,
    topModalOverride: topModalOverride
  }, componentTags), /*#__PURE__*/React.createElement(FocusTrap, {
    autoFocus: !disableAutoFocus,
    focusFirstElement: focusFirstElement,
    bespokeTrap: bespokeFocusTrap,
    wrapperRef: dialogRef,
    isOpen: open,
    additionalWrapperRefs: focusableContainers,
    focusableSelectors: focusableSelectors
  }, /*#__PURE__*/React.createElement(StyledDialogFullScreen, _extends({
    "aria-modal": role === "dialog" && isTopModal ? true : undefined
  }, ariaProps, {
    ref: dialogRef,
    "data-element": "dialog-full-screen",
    pagesStyling: pagesStyling,
    role: role
  }), dialogTitle(), closeIcon(), /*#__PURE__*/React.createElement(StyledContent, {
    hasHeader: title !== undefined,
    "data-element": "content",
    ref: contentRef,
    disableContentPadding: disableContentPadding,
    hasStickyFooter: hasStickyFooter
  }, children))));
};
export default DialogFullScreen;