function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import { filterStyledSystemMarginProps } from "../../style/utils";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import { StyledDetail, StyledDetailContent, StyledDetailIcon, StyledDetailFootnote } from "./detail.style";
export const Detail = ({
  className,
  icon,
  footnote,
  children,
  ...rest
}) => /*#__PURE__*/React.createElement(StyledDetail, _extends({
  className: `carbon-detail ${className}`
}, tagComponent("detail", rest), filterStyledSystemMarginProps(rest)), icon && /*#__PURE__*/React.createElement(StyledDetailIcon, {
  type: icon,
  "data-element": "icon"
}), /*#__PURE__*/React.createElement(StyledDetailContent, {
  "data-element": "detail-content",
  hasIcon: !!icon
}, children), footnote && /*#__PURE__*/React.createElement(StyledDetailFootnote, {
  "data-element": "footnote",
  hasIcon: !!icon
}, footnote));
Detail.displayName = "Detail";
export default Detail;