function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import { StyledDl } from "./definition-list.style";
import DlContext from "./__internal__/dl.context";
const Dl = ({
  children,
  w = 50,
  dtTextAlign = "right",
  ddTextAlign = "left",
  asSingleColumn = false,
  ...rest
}) => {
  return /*#__PURE__*/React.createElement(StyledDl, _extends({
    w: w,
    "data-component": "dl",
    asSingleColumn: asSingleColumn
  }, rest), /*#__PURE__*/React.createElement(DlContext.Provider, {
    value: {
      asSingleColumn,
      dtTextAlign,
      ddTextAlign
    }
  }, children));
};
Dl.displayName = "Dl";
export default Dl;