import React from "react";
import { SpaceProps } from "styled-system";
import { DlContextProps } from "./__internal__/dl.context";
export interface DlProps extends SpaceProps, DlContextProps {
    /** HTML id attribute of the input */
    id?: string;
    /** prop to render children. */
    children: React.ReactNode;
    /** This value will specify the width of the `StyledDtDiv` as a percentage. The remaining space will be taken up
      by the `StyledDdDiv`. This prop has no effect when `asSingleColumn` is set.
    */
    w?: number;
}
declare const Dl: {
    ({ children, w, dtTextAlign, ddTextAlign, asSingleColumn, ...rest }: DlProps): React.JSX.Element;
    displayName: string;
};
export default Dl;
