function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState, useEffect, useRef, useCallback, useContext } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import Textbox from "../textbox";
import LocaleContext from "../../__internal__/i18n-context";
import usePrevious from "../../hooks/__internal__/usePrevious";
import Logger from "../../__internal__/utils/logger";
let deprecateUncontrolledWarnTriggered = false;
const Decimal = /*#__PURE__*/React.forwardRef(({
  align = "right",
  defaultValue,
  precision = 2,
  inputWidth,
  readOnly,
  onChange,
  onBlur,
  onKeyPress,
  id,
  name,
  allowEmptyValue = false,
  locale,
  value,
  ...rest
}, ref) => {
  const l = useContext(LocaleContext);
  const getSeparator = useCallback(separatorType => {
    const numberWithGroupAndDecimalSeparator = 10000.1;
    return Intl.NumberFormat(locale || l.locale()).formatToParts(numberWithGroupAndDecimalSeparator).find(part => part.type === separatorType)?.value;
  }, [l, locale]);
  const isNaN = useCallback(valueToTest => {
    return Number.isNaN(Number(valueToTest));
  }, []);

  /**
   * Format a user defined value
   */
  const formatValue = useCallback(valueToFormat => {
    if (isNaN(valueToFormat)) {
      return valueToFormat;
    }

    /* Guards against any white-space only strings like "   " being 
    mishandled and returned as `NaN` for the value displayed in the textbox */
    if (valueToFormat === "" || valueToFormat.match(/\s+/g)) {
      return valueToFormat;
    }
    const separator = getSeparator("decimal");
    const [integer, remainder] = valueToFormat.split(".");
    const formattedInteger = Intl.NumberFormat(locale || l.locale(), {
      maximumFractionDigits: 0
    }).format(integer);
    let formattedNumber = formattedInteger;
    if (remainder?.length > precision) {
      formattedNumber += `${separator + remainder}`;
    } else if (remainder?.length <= precision) {
      formattedNumber += `${separator + remainder + "0".repeat(precision - remainder.length)}`;
    } else {
      formattedNumber += `${precision ? separator + "0".repeat(precision) : ""}`;
    }
    return formattedNumber;
  }, [getSeparator, isNaN, l, locale, precision]);
  const emptyValue = allowEmptyValue ? "" : formatValue(0 .toFixed(precision));
  const getSafeValueProp = useCallback(initialValue => {
    // We're intentionally preventing the use of number values to help prevent any unintentional rounding issues
    !(typeof initialValue === "string") ? process.env.NODE_ENV !== "production" ? invariant(false, "Decimal `value` prop must be a string") : invariant(false) : void 0;
    if (initialValue && !allowEmptyValue) {
      !(initialValue !== "") ? process.env.NODE_ENV !== "production" ? invariant(false, "Decimal `value` must not be an empty string. Please use `allowEmptyValue` or specify a non-empty initialValue") : invariant(false) : void 0;
    }
    return initialValue;
  }, [allowEmptyValue]);

  /**
   * Determine if the precision value has changed from the previous ref value for precision
   */
  const prevPrecisionValue = usePrevious(precision);
  useEffect(() => {
    if (prevPrecisionValue && prevPrecisionValue !== precision) {
      // eslint-disable-next-line no-console
      console.error("Decimal `precision` prop has changed value. Changing the Decimal `precision` prop has no effect.");
    }
  }, [precision, prevPrecisionValue]);
  const removeDelimiters = useCallback(valueToFormat => {
    const delimiterMatcher = new RegExp(`[\\${getSeparator("group")} ]*`, "g");
    return valueToFormat.replace(delimiterMatcher, "");
  }, [getSeparator]);

  /**
   * Convert raw input to a standard decimal format
   */
  const toStandardDecimal = useCallback(i18nValue => {
    const valueWithoutNBS = getSeparator("group")?.match(/\s+/) && !i18nValue.match(/\s{2,}/) ? i18nValue.replace(/\s+/g, "") : i18nValue;
    /* If a value is passed in that is a number but has too many delimiters in succession, we want to handle this
    value without formatting it or removing delimiters. We also want to consider that,
    if a value consists of only delimiters, we want to treat that 
    value in the same way as if the value was NaN. We want to pass this value to the 
    formatValue function, before the delimiters can be removed. */
    const errorsWithDelimiter = new RegExp(`([^A-Za-z0-9]{2,})|(^[^A-Za-z0-9-]+)|([^0-9a-z-,.])|([^0-9-,.]+)|([W,.])$`, "g");
    const separator = getSeparator("decimal");
    const separatorRegex = new RegExp(separator === "." ? `\\${separator}` : separator, "g");
    if (valueWithoutNBS.match(errorsWithDelimiter) || (valueWithoutNBS.match(separatorRegex) || []).length > 1) {
      return valueWithoutNBS;
    }
    const withoutDelimiters = removeDelimiters(valueWithoutNBS);
    return withoutDelimiters.replace(new RegExp(`\\${separator}`, "g"), ".");
  }, [getSeparator, removeDelimiters]);
  const decimalValue = getSafeValueProp(defaultValue || value || emptyValue);
  const [stateValue, setStateValue] = useState(isNaN(toStandardDecimal(decimalValue)) ? decimalValue : formatValue(decimalValue));
  const createEvent = (formatted, raw) => {
    return {
      target: {
        name,
        id,
        value: {
          formattedValue: formatValue(toStandardDecimal(formatted)),
          rawValue: raw || toStandardDecimal(formatted)
        }
      }
    };
  };
  const handleOnChange = ev => {
    const {
      value: val
    } = ev.target;
    setStateValue(val);
    if (onChange) onChange(createEvent(val));
  };
  const handleOnBlur = ev => {
    const {
      value: updatedValue
    } = ev.target;
    let event;
    if (updatedValue) {
      const standardVisible = toStandardDecimal(updatedValue);
      const formattedValue = isNaN(standardVisible) ? updatedValue : formatValue(standardVisible);
      event = createEvent(formattedValue, standardVisible);
      setStateValue(formattedValue);
    } else {
      event = createEvent(emptyValue);
      setStateValue(emptyValue);
    }
    if (onBlur) onBlur(event);
  };
  const isControlled = value !== undefined;
  const prevControlledRef = useRef();
  useEffect(() => {
    const message = "Input elements should not switch from uncontrolled to controlled (or vice versa). " + "Decide between using a controlled or uncontrolled input element for the lifetime of the component";
    !(prevControlledRef.current !== isControlled) ? process.env.NODE_ENV !== "production" ? invariant(false, message) : invariant(false) : void 0;
    prevControlledRef.current = isControlled;
  }, [isControlled]);
  const prevValue = usePrevious(value);
  useEffect(() => {
    const standardDecimalValue = toStandardDecimal(stateValue);
    if (isControlled) {
      const valueProp = getSafeValueProp(value);
      if (standardDecimalValue !== valueProp) {
        if (valueProp === "" && prevValue === "") {
          setStateValue(formatValue(emptyValue));
        } else {
          setStateValue(formatValue(valueProp));
        }
      }
    }
  }, [emptyValue, formatValue, getSafeValueProp, isControlled, prevValue, stateValue, toStandardDecimal, value]);
  if (!deprecateUncontrolledWarnTriggered && !isControlled) {
    deprecateUncontrolledWarnTriggered = true;
    Logger.deprecate("Uncontrolled behaviour in `Decimal` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Textbox, _extends({
    onKeyPress: onKeyPress,
    align: align,
    readOnly: readOnly,
    inputWidth: inputWidth,
    onChange: handleOnChange,
    onBlur: handleOnBlur,
    value: stateValue,
    "data-component": "decimal",
    id: id,
    ref: ref
  }, rest)), /*#__PURE__*/React.createElement("input", {
    name: name,
    value: toStandardDecimal(stateValue),
    type: "hidden",
    "data-component": "hidden-input"
  }));
});
if (process.env.NODE_ENV !== "production") {
  Decimal.propTypes = {
    "about": PropTypes.string,
    "accept": PropTypes.string,
    "accessKey": PropTypes.string,
    "adaptiveLabelBreakpoint": PropTypes.number,
    "align": PropTypes.oneOf(["left", "right"]),
    "allowEmptyValue": PropTypes.bool,
    "alt": PropTypes.string,
    "aria-activedescendant": PropTypes.string,
    "aria-atomic": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-autocomplete": PropTypes.oneOf(["both", "inline", "list", "none"]),
    "aria-busy": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-checked": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-colcount": PropTypes.number,
    "aria-colindex": PropTypes.number,
    "aria-colspan": PropTypes.number,
    "aria-controls": PropTypes.string,
    "aria-current": PropTypes.oneOfType([PropTypes.oneOf(["date", "false", "location", "page", "step", "time", "true"]), PropTypes.bool]),
    "aria-describedby": PropTypes.string,
    "aria-details": PropTypes.string,
    "aria-disabled": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-dropeffect": PropTypes.oneOf(["copy", "execute", "link", "move", "none", "popup"]),
    "aria-errormessage": PropTypes.string,
    "aria-expanded": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-flowto": PropTypes.string,
    "aria-grabbed": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-haspopup": PropTypes.oneOfType([PropTypes.oneOf(["dialog", "false", "grid", "listbox", "menu", "tree", "true"]), PropTypes.bool]),
    "aria-hidden": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-invalid": PropTypes.oneOfType([PropTypes.oneOf(["false", "grammar", "spelling", "true"]), PropTypes.bool]),
    "aria-keyshortcuts": PropTypes.string,
    "aria-label": PropTypes.string,
    "aria-labelledby": PropTypes.string,
    "aria-level": PropTypes.number,
    "aria-live": PropTypes.oneOf(["assertive", "off", "polite"]),
    "aria-modal": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiline": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiselectable": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-orientation": PropTypes.oneOf(["horizontal", "vertical"]),
    "aria-owns": PropTypes.string,
    "aria-placeholder": PropTypes.string,
    "aria-posinset": PropTypes.number,
    "aria-pressed": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-readonly": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-relevant": PropTypes.oneOf(["additions removals", "additions text", "additions", "all", "removals additions", "removals text", "removals", "text additions", "text removals", "text"]),
    "aria-required": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-roledescription": PropTypes.string,
    "aria-rowcount": PropTypes.number,
    "aria-rowindex": PropTypes.number,
    "aria-rowspan": PropTypes.number,
    "aria-selected": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-setsize": PropTypes.number,
    "aria-sort": PropTypes.oneOf(["ascending", "descending", "none", "other"]),
    "aria-valuemax": PropTypes.number,
    "aria-valuemin": PropTypes.number,
    "aria-valuenow": PropTypes.number,
    "aria-valuetext": PropTypes.string,
    "ariaDescribedBy": PropTypes.string,
    "as": PropTypes.elementType,
    "autoCapitalize": PropTypes.string,
    "autoComplete": PropTypes.string,
    "autoCorrect": PropTypes.string,
    "autoFocus": PropTypes.bool,
    "autoSave": PropTypes.string,
    "capture": PropTypes.oneOfType([PropTypes.oneOf(["environment", "user"]), PropTypes.bool]),
    "checked": PropTypes.bool,
    "children": PropTypes.node,
    "className": PropTypes.string,
    "color": PropTypes.string,
    "content": PropTypes.string,
    "contentEditable": PropTypes.oneOfType([PropTypes.oneOf(["false", "inherit", "true"]), PropTypes.bool]),
    "contextMenu": PropTypes.string,
    "dangerouslySetInnerHTML": PropTypes.shape({
      "__html": PropTypes.oneOfType([PropTypes.object, PropTypes.string]).isRequired
    }),
    "data-component": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "datatype": PropTypes.string,
    "defaultChecked": PropTypes.bool,
    "defaultValue": PropTypes.string,
    "deferTimeout": PropTypes.number,
    "dir": PropTypes.string,
    "disabled": PropTypes.bool,
    "draggable": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "enterKeyHint": PropTypes.oneOf(["done", "enter", "go", "next", "previous", "search", "send"]),
    "error": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "fieldHelp": PropTypes.node,
    "form": PropTypes.string,
    "formAction": PropTypes.string,
    "formattedValue": PropTypes.string,
    "formEncType": PropTypes.string,
    "formMethod": PropTypes.string,
    "formNoValidate": PropTypes.bool,
    "formTarget": PropTypes.string,
    "height": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "helpAriaLabel": PropTypes.string,
    "hidden": PropTypes.bool,
    "iconOnClick": PropTypes.func,
    "iconOnMouseDown": PropTypes.func,
    "iconTabIndex": PropTypes.number,
    "id": PropTypes.string,
    "info": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "inlist": PropTypes.any,
    "inputHint": PropTypes.string,
    "inputIcon": PropTypes.oneOf(["accessibility_web", "add", "admin", "alert_on", "alert", "analysis", "app_facebook", "app_instagram", "app_tiktok", "app_twitter", "app_youtube", "apps", "arrow_bottom_right_circle", "arrow_down", "arrow_left_boxed", "arrow_left_right_small", "arrow_left_small", "arrow_left", "arrow_right_small", "arrow_right", "arrow_top_left_circle", "arrow_up", "arrow", "arrows_left_right", "attach", "bank_with_card", "bank", "basket_with_squares", "basket", "bed", "bill_paid", "bill_unpaid", "bin", "biometric", "block_arrow_right", "blocked_square", "blocked", "bold", "box_arrow_left", "box_arrow_right", "boxed_shapes", "bulk_destroy", "bullet_list_dotted", "bullet_list_numbers", "bullet_list", "business", "calendar_pay_date", "calendar_today", "calendar", "call", "camera", "car_lock", "car_money", "car_repair", "card_view", "card_wallet", "caret_down", "caret_large_down", "caret_large_left", "caret_large_right", "caret_large_up", "caret_left", "caret_right", "caret_up", "cart", "cash", "chart_bar", "chart_line", "chart_pie", "chat_notes", "chat", "check_all", "check_none", "chevron_down_thick", "chevron_down", "chevron_left_thick", "chevron_left", "chevron_right_thick", "chevron_right", "chevron_up_thick", "chevron_up", "circle_with_dots", "circles_connection", "clock", "close", "cloud_co2", "coins", "collaborate", "computer_clock", "connect_off", "connect", "construction", "contact_card", "contacts", "copy", "create", "credit_card_slash", "credit_card", "cross_circle", "cross", "csv", "dashboard", "delete", "delivery", "disconnect", "disputed", "document_right_align", "document_tick", "document_vertical_lines", "download", "draft", "drag_vertical", "drag", "drill", "dropdown", "duplicate", "edit", "edited", "ellipsis_horizontal", "ellipsis_vertical", "email_switch", "email", "entry", "envelope_dollar", "envelope_euro", "error_square", "error", "euro", "expand", "export", "factory", "favourite_lined", "favourite", "fax", "feedback", "file_excel", "file_generic", "file_image", "file_pdf", "file_word", "files_leaning", "filter_new", "filter", "fit_height", "fit_width", "flag", "folder", "form_refresh", "gift", "go", "graduation_hat", "graph", "grid", "hand_cash_coins", "hand_cash_note", "heart_pulse", "help", "hide", "home", "image", "import", "in_progress", "in_transit", "individual", "info", "intranet", "italic", "job_seeked", "key", "laptop", "leaf", "ledger_arrow_left", "ledger_arrow_right", "ledger", "lightbulb_off", "lightbulb_on", "like_no", "like", "link_cloud", "link_on", "link", "list_view", "location", "locked", "logout", "lookup", "marker", "message", "microphone", "minimise", "minus_large", "minus", "mobile", "money_bag", "none", "old_warning", "palm_tree", "pause_circle", "pause", "pdf", "people_switch", "people", "percentage_boxed", "person_info", "person_tick", "person", "petrol_pump", "phone", "piggy_bank", "pin", "plane", "play_circle", "play", "plus_large", "plus", "pound", "print", "progress", "progressed", "protect", "question_hollow", "question_mark", "question", "recruiting", "refresh_clock", "refresh", "remove", "sage_coin", "save", "scan", "search", "send", "services", "settings_old", "settings", "share", "shop", "sort_down", "sort_up", "spanner", "split_container", "split", "square_dot", "squares_nine", "stacked_boxes", "stacked_squares", "submitted", "support_online", "sync", "tag", "talk", "target_man", "target", "theatre_masks", "three_boxes", "tick_circle", "tick_thick", "tick", "true_tick", "u_turn_left", "u_turn_right", "undo", "unlocked", "upload", "uploaded", "video", "view", "volunteering", "warning", "website", "welfare"]),
    "inputMode": PropTypes.oneOf(["decimal", "email", "none", "numeric", "search", "tel", "text", "url"]),
    "inputWidth": PropTypes.number,
    "is": PropTypes.string,
    "isOptional": PropTypes.bool,
    "itemID": PropTypes.string,
    "itemProp": PropTypes.string,
    "itemRef": PropTypes.string,
    "itemScope": PropTypes.bool,
    "itemType": PropTypes.string,
    "label": PropTypes.string,
    "labelAlign": PropTypes.oneOf(["left", "right"]),
    "labelHelp": PropTypes.node,
    "labelInline": PropTypes.bool,
    "labelSpacing": PropTypes.oneOf([1, 2]),
    "labelWidth": PropTypes.number,
    "lang": PropTypes.string,
    "leftChildren": PropTypes.node,
    "list": PropTypes.string,
    "locale": PropTypes.string,
    "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "max": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "maxLength": PropTypes.number,
    "maxWidth": PropTypes.string,
    "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "min": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "minLength": PropTypes.number,
    "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "multiple": PropTypes.bool,
    "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "name": PropTypes.string,
    "nonce": PropTypes.string,
    "onAbort": PropTypes.func,
    "onAbortCapture": PropTypes.func,
    "onAnimationEnd": PropTypes.func,
    "onAnimationEndCapture": PropTypes.func,
    "onAnimationIteration": PropTypes.func,
    "onAnimationIterationCapture": PropTypes.func,
    "onAnimationStart": PropTypes.func,
    "onAnimationStartCapture": PropTypes.func,
    "onAuxClick": PropTypes.func,
    "onAuxClickCapture": PropTypes.func,
    "onBeforeInput": PropTypes.func,
    "onBeforeInputCapture": PropTypes.func,
    "onBlur": PropTypes.func,
    "onBlurCapture": PropTypes.func,
    "onCanPlay": PropTypes.func,
    "onCanPlayCapture": PropTypes.func,
    "onCanPlayThrough": PropTypes.func,
    "onCanPlayThroughCapture": PropTypes.func,
    "onChange": PropTypes.func,
    "onChangeCapture": PropTypes.func,
    "onChangeDeferred": PropTypes.func,
    "onClick": PropTypes.func,
    "onClickCapture": PropTypes.func,
    "onCompositionEnd": PropTypes.func,
    "onCompositionEndCapture": PropTypes.func,
    "onCompositionStart": PropTypes.func,
    "onCompositionStartCapture": PropTypes.func,
    "onCompositionUpdate": PropTypes.func,
    "onCompositionUpdateCapture": PropTypes.func,
    "onContextMenu": PropTypes.func,
    "onContextMenuCapture": PropTypes.func,
    "onCopy": PropTypes.func,
    "onCopyCapture": PropTypes.func,
    "onCut": PropTypes.func,
    "onCutCapture": PropTypes.func,
    "onDoubleClick": PropTypes.func,
    "onDoubleClickCapture": PropTypes.func,
    "onDrag": PropTypes.func,
    "onDragCapture": PropTypes.func,
    "onDragEnd": PropTypes.func,
    "onDragEndCapture": PropTypes.func,
    "onDragEnter": PropTypes.func,
    "onDragEnterCapture": PropTypes.func,
    "onDragExit": PropTypes.func,
    "onDragExitCapture": PropTypes.func,
    "onDragLeave": PropTypes.func,
    "onDragLeaveCapture": PropTypes.func,
    "onDragOver": PropTypes.func,
    "onDragOverCapture": PropTypes.func,
    "onDragStart": PropTypes.func,
    "onDragStartCapture": PropTypes.func,
    "onDrop": PropTypes.func,
    "onDropCapture": PropTypes.func,
    "onDurationChange": PropTypes.func,
    "onDurationChangeCapture": PropTypes.func,
    "onEmptied": PropTypes.func,
    "onEmptiedCapture": PropTypes.func,
    "onEncrypted": PropTypes.func,
    "onEncryptedCapture": PropTypes.func,
    "onEnded": PropTypes.func,
    "onEndedCapture": PropTypes.func,
    "onError": PropTypes.func,
    "onErrorCapture": PropTypes.func,
    "onFocus": PropTypes.func,
    "onFocusCapture": PropTypes.func,
    "onGotPointerCapture": PropTypes.func,
    "onGotPointerCaptureCapture": PropTypes.func,
    "onInput": PropTypes.func,
    "onInputCapture": PropTypes.func,
    "onInvalid": PropTypes.func,
    "onInvalidCapture": PropTypes.func,
    "onKeyDown": PropTypes.func,
    "onKeyDownCapture": PropTypes.func,
    "onKeyPress": PropTypes.func,
    "onKeyPressCapture": PropTypes.func,
    "onKeyUp": PropTypes.func,
    "onKeyUpCapture": PropTypes.func,
    "onLoad": PropTypes.func,
    "onLoadCapture": PropTypes.func,
    "onLoadedData": PropTypes.func,
    "onLoadedDataCapture": PropTypes.func,
    "onLoadedMetadata": PropTypes.func,
    "onLoadedMetadataCapture": PropTypes.func,
    "onLoadStart": PropTypes.func,
    "onLoadStartCapture": PropTypes.func,
    "onLostPointerCapture": PropTypes.func,
    "onLostPointerCaptureCapture": PropTypes.func,
    "onMouseDown": PropTypes.func,
    "onMouseDownCapture": PropTypes.func,
    "onMouseEnter": PropTypes.func,
    "onMouseLeave": PropTypes.func,
    "onMouseMove": PropTypes.func,
    "onMouseMoveCapture": PropTypes.func,
    "onMouseOut": PropTypes.func,
    "onMouseOutCapture": PropTypes.func,
    "onMouseOver": PropTypes.func,
    "onMouseOverCapture": PropTypes.func,
    "onMouseUp": PropTypes.func,
    "onMouseUpCapture": PropTypes.func,
    "onPaste": PropTypes.func,
    "onPasteCapture": PropTypes.func,
    "onPause": PropTypes.func,
    "onPauseCapture": PropTypes.func,
    "onPlay": PropTypes.func,
    "onPlayCapture": PropTypes.func,
    "onPlaying": PropTypes.func,
    "onPlayingCapture": PropTypes.func,
    "onPointerCancel": PropTypes.func,
    "onPointerCancelCapture": PropTypes.func,
    "onPointerDown": PropTypes.func,
    "onPointerDownCapture": PropTypes.func,
    "onPointerEnter": PropTypes.func,
    "onPointerEnterCapture": PropTypes.func,
    "onPointerLeave": PropTypes.func,
    "onPointerLeaveCapture": PropTypes.func,
    "onPointerMove": PropTypes.func,
    "onPointerMoveCapture": PropTypes.func,
    "onPointerOut": PropTypes.func,
    "onPointerOutCapture": PropTypes.func,
    "onPointerOver": PropTypes.func,
    "onPointerOverCapture": PropTypes.func,
    "onPointerUp": PropTypes.func,
    "onPointerUpCapture": PropTypes.func,
    "onProgress": PropTypes.func,
    "onProgressCapture": PropTypes.func,
    "onRateChange": PropTypes.func,
    "onRateChangeCapture": PropTypes.func,
    "onReset": PropTypes.func,
    "onResetCapture": PropTypes.func,
    "onScroll": PropTypes.func,
    "onScrollCapture": PropTypes.func,
    "onSeeked": PropTypes.func,
    "onSeekedCapture": PropTypes.func,
    "onSeeking": PropTypes.func,
    "onSeekingCapture": PropTypes.func,
    "onSelect": PropTypes.func,
    "onSelectCapture": PropTypes.func,
    "onStalled": PropTypes.func,
    "onStalledCapture": PropTypes.func,
    "onSubmit": PropTypes.func,
    "onSubmitCapture": PropTypes.func,
    "onSuspend": PropTypes.func,
    "onSuspendCapture": PropTypes.func,
    "onTimeUpdate": PropTypes.func,
    "onTimeUpdateCapture": PropTypes.func,
    "onTouchCancel": PropTypes.func,
    "onTouchCancelCapture": PropTypes.func,
    "onTouchEnd": PropTypes.func,
    "onTouchEndCapture": PropTypes.func,
    "onTouchMove": PropTypes.func,
    "onTouchMoveCapture": PropTypes.func,
    "onTouchStart": PropTypes.func,
    "onTouchStartCapture": PropTypes.func,
    "onTransitionEnd": PropTypes.func,
    "onTransitionEndCapture": PropTypes.func,
    "onVolumeChange": PropTypes.func,
    "onVolumeChangeCapture": PropTypes.func,
    "onWaiting": PropTypes.func,
    "onWaitingCapture": PropTypes.func,
    "onWheel": PropTypes.func,
    "onWheelCapture": PropTypes.func,
    "pattern": PropTypes.string,
    "placeholder": PropTypes.string,
    "precision": PropTypes.oneOf([0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]),
    "prefix": PropTypes.string,
    "property": PropTypes.string,
    "radioGroup": PropTypes.string,
    "readOnly": PropTypes.bool,
    "rel": PropTypes.string,
    "required": PropTypes.bool,
    "resource": PropTypes.string,
    "results": PropTypes.number,
    "rev": PropTypes.string,
    "reverse": PropTypes.bool,
    "role": PropTypes.oneOfType([PropTypes.oneOf(["alert", "alertdialog", "application", "article", "banner", "button", "cell", "checkbox", "columnheader", "combobox", "complementary", "contentinfo", "definition", "dialog", "directory", "document", "feed", "figure", "form", "grid", "gridcell", "group", "heading", "img", "link", "list", "listbox", "listitem", "log", "main", "marquee", "math", "menu", "menubar", "menuitem", "menuitemcheckbox", "menuitemradio", "navigation", "none", "note", "option", "presentation", "progressbar", "radio", "radiogroup", "region", "row", "rowgroup", "rowheader", "scrollbar", "search", "searchbox", "separator", "slider", "spinbutton", "status", "switch", "tab", "table", "tablist", "tabpanel", "term", "textbox", "timer", "toolbar", "tooltip", "tree", "treegrid", "treeitem"]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "security": PropTypes.string,
    "size": PropTypes.oneOf(["large", "medium", "small"]),
    "slot": PropTypes.string,
    "spellCheck": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "src": PropTypes.string,
    "step": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "style": PropTypes.object,
    "suppressContentEditableWarning": PropTypes.bool,
    "suppressHydrationWarning": PropTypes.bool,
    "tabIndex": PropTypes.number,
    "title": PropTypes.string,
    "tooltipPosition": PropTypes.oneOf(["bottom", "left", "right", "top"]),
    "translate": PropTypes.oneOf(["no", "yes"]),
    "typeof": PropTypes.string,
    "unselectable": PropTypes.oneOf(["off", "on"]),
    "validationIconId": PropTypes.string,
    "validationOnLabel": PropTypes.bool,
    "value": PropTypes.string,
    "vocab": PropTypes.string,
    "warning": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "width": PropTypes.oneOfType([PropTypes.number, PropTypes.string])
  };
}
export { Decimal };
Decimal.displayName = "Decimal";
export default Decimal;