import React from "react";
import { CommonTextboxProps } from "../textbox";
export interface CustomEvent {
    target: {
        name?: string;
        id?: string;
        value: {
            formattedValue: string;
            rawValue: string;
        };
    };
}
export interface DecimalProps extends Omit<CommonTextboxProps, "onChange" | "onBlur"> {
    /** Text alignment of the label */
    align?: "left" | "right";
    /** Allow an empty value instead of defaulting to 0.00 */
    allowEmptyValue?: boolean;
    /** The default value of the input if it's meant to be used as an uncontrolled component */
    defaultValue?: string;
    /** The input id */
    id?: string;
    /** The width of the input as a percentage */
    inputWidth?: number;
    /** Handler for change event if input is meant to be used as a controlled component */
    onChange?: (ev: CustomEvent) => void;
    /** Handler for blur event */
    onBlur?: (ev: CustomEvent) => void;
    /** Handler for key press event */
    onKeyPress?: (ev: React.KeyboardEvent<HTMLInputElement>) => void;
    /** The input name */
    name?: string;
    /** The decimal precision of the value in the input */
    precision?: 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11 | 12 | 13 | 14 | 15;
    /** If true, the component will be read-only */
    readOnly?: boolean;
    /** The value of the input if it's used as a controlled component */
    value?: string;
    /** The locale string - default en */
    locale?: string;
}
export declare const Decimal: React.ForwardRefExoticComponent<DecimalProps & React.RefAttributes<HTMLInputElement>>;
export default Decimal;
