function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext, useEffect, useMemo, useRef, useState, useCallback } from "react";
import PropTypes from "prop-types";
import { additionalYears, findMatchedFormatAndValue, formattedValue, formatToISO, isDateValid, parseDate, parseISODate, checkISOFormatAndLength, getSeparator } from "./__internal__/utils";
import useLocale from "../../hooks/__internal__/useLocale";
import Events from "../../__internal__/utils/helpers/events";
import { filterOutStyledSystemSpacingProps } from "../../style/utils";
import getFormatData from "./__internal__/date-formats";
import StyledDateInput from "./date.style";
import Textbox from "../textbox";
import DatePicker from "./__internal__/date-picker";
import DateRangeContext from "../date-range/date-range.context";
import useClickAwayListener from "../../hooks/__internal__/useClickAwayListener";
import useFormSpacing from "../../hooks/__internal__/useFormSpacing";
import guid from "../../__internal__/utils/helpers/guid";
const DateInput = /*#__PURE__*/React.forwardRef(({
  adaptiveLabelBreakpoint,
  allowEmptyValue,
  autoFocus,
  "data-component": dataComponent,
  "data-element": dataElement,
  "data-role": dataRole,
  disabled,
  disablePortal = false,
  helpAriaLabel,
  labelInline,
  minDate,
  maxDate,
  onBlur,
  onChange,
  onClick,
  onFocus,
  onKeyDown,
  pickerProps = {},
  readOnly,
  size = "medium",
  tooltipPosition,
  value,
  inputWidth,
  labelWidth,
  maxWidth,
  inputName,
  ...rest
}, ref) => {
  const wrapperRef = useRef(null);
  const parentRef = useRef(null);
  const internalInputRef = useRef(null);
  const alreadyFocused = useRef(false);
  const isBlurBlocked = useRef(false);
  const focusedViaPicker = useRef(false);
  const l = useLocale();
  const {
    dateFnsLocale
  } = l.date;
  const {
    format,
    formats
  } = useMemo(() => getFormatData(dateFnsLocale()), [dateFnsLocale]);
  const {
    inputRefMap,
    setInputRefMap
  } = useContext(DateRangeContext);
  const [open, setOpen] = useState(false);
  const [selectedDays, setSelectedDays] = useState(checkISOFormatAndLength(value) ? parseISODate(value) : parseDate(format, value));
  const isInitialValue = useRef(true);
  const pickerTabGuardId = useRef(guid());
  const computeInvalidRawValue = inputValue => allowEmptyValue && !inputValue.length ? inputValue : null;
  const buildCustomEvent = ev => {
    const {
      id,
      name
    } = ev.target;
    const [matchedFormat, matchedValue] = findMatchedFormatAndValue(ev.target.value, formats);
    const formattedValueString = ev.type === "blur" ? formattedValue(format, selectedDays) : ev.target.value;
    const rawValue = isDateValid(parseDate(matchedFormat, matchedValue)) ? formatToISO(...additionalYears(matchedFormat, matchedValue)) : computeInvalidRawValue(ev.target.value);
    const customEvent = {
      target: {
        ...(name && {
          name
        }),
        ...(id && {
          id
        }),
        value: {
          formattedValue: formattedValueString,
          rawValue
        }
      }
    };
    return customEvent;
  };
  const handleClickAway = () => {
    if (open) {
      alreadyFocused.current = true;
      internalInputRef.current?.focus();
      isBlurBlocked.current = false;
      internalInputRef.current?.blur();
      setOpen(false);
      alreadyFocused.current = false;
    }
  };
  const handleClickInside = useClickAwayListener(handleClickAway, "mousedown");
  const handleChange = ev => {
    isInitialValue.current = false;
    onChange(buildCustomEvent(ev));
  };
  const focusInput = () => {
    focusedViaPicker.current = true;
    internalInputRef.current?.focus();
  };
  const handleDayClick = (day, ev) => {
    setSelectedDays(day);
    onChange(buildCustomEvent({
      ...ev,
      target: {
        ...ev.target,
        value: formattedValue(format, day)
      }
    }));
    focusInput();
    setOpen(false);
  };
  const handleBlur = ev => {
    if (disabled || readOnly) {
      return;
    }
    let event;
    if (isDateValid(selectedDays)) {
      event = buildCustomEvent(ev);
      const currentValue = checkISOFormatAndLength(value) ? formattedValue(format, parseISODate(value)) : value;
      const [, matchedValue] = findMatchedFormatAndValue(currentValue, formats);
      if (formattedValue(format, selectedDays) !== matchedValue) {
        onChange(event);
      }
    } else {
      const {
        id,
        name
      } = ev.target;
      event = {
        target: {
          ...(name && {
            name
          }),
          ...(id && {
            id
          }),
          value: {
            formattedValue: ev.target.value,
            rawValue: computeInvalidRawValue(ev.target.value)
          }
        }
      };
    }
    if (isBlurBlocked.current) {
      return;
    }
    if (onBlur) {
      onBlur(event);
    }
  };
  const handleFocus = ev => {
    if (disabled || readOnly) {
      return;
    }
    isBlurBlocked.current = false;
    if (!open && !alreadyFocused.current) {
      setOpen(true);
    } else {
      alreadyFocused.current = false;
    }
    if (onFocus) {
      onFocus(ev);
    }
  };
  const handleKeyUp = useCallback(ev => {
    /* istanbul ignore else */
    if (open && Events.isEscKey(ev)) {
      setOpen(false);
      ev.stopPropagation();
    }
  }, [open]);
  const handleKeyDown = ev => {
    if (onKeyDown) {
      onKeyDown(ev);
    }
    if (open && Events.isTabKey(ev)) {
      if (Events.isShiftKey(ev)) {
        setOpen(false);
      } else if (!disablePortal) {
        ev.preventDefault();
        document?.querySelector(`[id="${pickerTabGuardId.current}"]`)?.focus();
      }
      alreadyFocused.current = false;
    }
  };
  const handleClick = ev => {
    if (onClick) {
      onClick(ev);
    }
  };
  const handleMouseDown = ev => {
    handleClickInside();
    if (setInputRefMap) {
      isBlurBlocked.current = true;
    }
    const {
      type
    } = ev.target;
    if (type !== "text") {
      alreadyFocused.current = true;
      setOpen(prev => !prev);
    } else if (!open) {
      setOpen(true);
    }
  };
  const handleIconMouseDown = ev => {
    isBlurBlocked.current = true;
    handleMouseDown(ev);
  };
  const handlePickerMouseDown = () => {
    isBlurBlocked.current = true;
    handleClickInside();
  };
  const assignInput = useCallback(inputElement => {
    internalInputRef.current = inputElement;
    parentRef.current = inputElement?.parentElement;
    if (ref) {
      if (typeof ref === "function") {
        ref(inputElement);
      } else {
        ref.current = inputElement;
      }
    }
    if (inputName && inputRefMap?.[inputName]?.setOpen !== setOpen) {
      setInputRefMap?.({
        [inputName]: {
          isBlurBlocked,
          setOpen
        }
      });
    }
  }, [inputName, inputRefMap, setInputRefMap, ref]);
  useEffect(() => {
    const [matchedFormat, matchedValue] = findMatchedFormatAndValue(value, formats);
    if (matchedFormat && matchedValue && isDateValid(parseDate(matchedFormat, matchedValue))) {
      setSelectedDays(parseDate(...additionalYears(matchedFormat, matchedValue)));
    } else if (checkISOFormatAndLength(value) && isInitialValue.current) {
      setSelectedDays(parseISODate(value));
    } else {
      setSelectedDays(undefined);
    }
  }, [value, formats]);
  const computedValue = () => {
    if (checkISOFormatAndLength(value) && isInitialValue.current) {
      return formattedValue(format, parseISODate(value));
    }
    const valueSeparator = getSeparator(value);
    const formatSeparator = getSeparator(format);
    const replaceSeparators = () => value.split("").map(char => char === valueSeparator ? formatSeparator : char).join("");
    if (isInitialValue.current && valueSeparator !== formatSeparator && isDateValid(parseDate(format, replaceSeparators()))) {
      isInitialValue.current = false;
      const [matchedFormat, matchedValue] = findMatchedFormatAndValue(replaceSeparators(), formats);
      return formattedValue(format, parseDate(...additionalYears(matchedFormat, matchedValue)));
    }
    return value;
  };
  const marginProps = useFormSpacing(rest);
  return /*#__PURE__*/React.createElement(StyledDateInput, _extends({
    ref: wrapperRef,
    role: "presentation",
    size: size,
    labelInline: labelInline,
    "data-component": dataComponent || "date",
    "data-element": dataElement,
    "data-role": dataRole
  }, marginProps, {
    applyDateRangeStyling: !!inputRefMap,
    maxWidth: maxWidth,
    inputWidth: inputWidth
  }), /*#__PURE__*/React.createElement(Textbox, _extends({}, filterOutStyledSystemSpacingProps(rest), {
    value: computedValue(),
    onBlur: handleBlur,
    onChange: handleChange,
    onClick: handleClick,
    onFocus: handleFocus,
    onKeyUp: handleKeyUp,
    onKeyDown: handleKeyDown,
    iconOnClick: handleClick,
    onMouseDown: handleMouseDown,
    iconOnMouseDown: handleIconMouseDown,
    inputIcon: "calendar",
    labelInline: labelInline,
    ref: assignInput,
    adaptiveLabelBreakpoint: adaptiveLabelBreakpoint,
    tooltipPosition: tooltipPosition,
    helpAriaLabel: helpAriaLabel,
    autoFocus: autoFocus,
    size: size,
    disabled: disabled,
    readOnly: readOnly,
    inputWidth: inputWidth,
    labelWidth: labelWidth,
    maxWidth: maxWidth,
    m: 0
  })), /*#__PURE__*/React.createElement(DatePicker, {
    disablePortal: disablePortal,
    inputElement: parentRef,
    pickerProps: pickerProps,
    selectedDays: selectedDays,
    onDayClick: handleDayClick,
    minDate: minDate,
    maxDate: maxDate,
    pickerMouseDown: handlePickerMouseDown,
    open: open,
    setOpen: setOpen,
    pickerTabGuardId: pickerTabGuardId.current
  }));
});
if (process.env.NODE_ENV !== "production") {
  DateInput.propTypes = {
    "about": PropTypes.string,
    "accept": PropTypes.string,
    "accessKey": PropTypes.string,
    "adaptiveLabelBreakpoint": PropTypes.number,
    "align": PropTypes.oneOf(["left", "right"]),
    "allowEmptyValue": PropTypes.bool,
    "alt": PropTypes.string,
    "aria-activedescendant": PropTypes.string,
    "aria-atomic": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-autocomplete": PropTypes.oneOf(["both", "inline", "list", "none"]),
    "aria-busy": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-checked": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-colcount": PropTypes.number,
    "aria-colindex": PropTypes.number,
    "aria-colspan": PropTypes.number,
    "aria-controls": PropTypes.string,
    "aria-current": PropTypes.oneOfType([PropTypes.oneOf(["date", "false", "location", "page", "step", "time", "true"]), PropTypes.bool]),
    "aria-describedby": PropTypes.string,
    "aria-details": PropTypes.string,
    "aria-disabled": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-dropeffect": PropTypes.oneOf(["copy", "execute", "link", "move", "none", "popup"]),
    "aria-errormessage": PropTypes.string,
    "aria-expanded": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-flowto": PropTypes.string,
    "aria-grabbed": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-haspopup": PropTypes.oneOfType([PropTypes.oneOf(["dialog", "false", "grid", "listbox", "menu", "tree", "true"]), PropTypes.bool]),
    "aria-hidden": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-invalid": PropTypes.oneOfType([PropTypes.oneOf(["false", "grammar", "spelling", "true"]), PropTypes.bool]),
    "aria-keyshortcuts": PropTypes.string,
    "aria-label": PropTypes.string,
    "aria-labelledby": PropTypes.string,
    "aria-level": PropTypes.number,
    "aria-live": PropTypes.oneOf(["assertive", "off", "polite"]),
    "aria-modal": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiline": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiselectable": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-orientation": PropTypes.oneOf(["horizontal", "vertical"]),
    "aria-owns": PropTypes.string,
    "aria-placeholder": PropTypes.string,
    "aria-posinset": PropTypes.number,
    "aria-pressed": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-readonly": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-relevant": PropTypes.oneOf(["additions removals", "additions text", "additions", "all", "removals additions", "removals text", "removals", "text additions", "text removals", "text"]),
    "aria-required": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-roledescription": PropTypes.string,
    "aria-rowcount": PropTypes.number,
    "aria-rowindex": PropTypes.number,
    "aria-rowspan": PropTypes.number,
    "aria-selected": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-setsize": PropTypes.number,
    "aria-sort": PropTypes.oneOf(["ascending", "descending", "none", "other"]),
    "aria-valuemax": PropTypes.number,
    "aria-valuemin": PropTypes.number,
    "aria-valuenow": PropTypes.number,
    "aria-valuetext": PropTypes.string,
    "ariaDescribedBy": PropTypes.string,
    "as": PropTypes.elementType,
    "autoCapitalize": PropTypes.string,
    "autoComplete": PropTypes.string,
    "autoCorrect": PropTypes.string,
    "autoFocus": PropTypes.bool,
    "autoSave": PropTypes.string,
    "capture": PropTypes.oneOfType([PropTypes.oneOf(["environment", "user"]), PropTypes.bool]),
    "checked": PropTypes.bool,
    "className": PropTypes.string,
    "color": PropTypes.string,
    "content": PropTypes.string,
    "contentEditable": PropTypes.oneOfType([PropTypes.oneOf(["false", "inherit", "true"]), PropTypes.bool]),
    "contextMenu": PropTypes.string,
    "dangerouslySetInnerHTML": PropTypes.shape({
      "__html": PropTypes.oneOfType([PropTypes.object, PropTypes.string]).isRequired
    }),
    "data-component": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "datatype": PropTypes.string,
    "defaultChecked": PropTypes.bool,
    "defaultValue": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.string), PropTypes.number, PropTypes.string]),
    "dir": PropTypes.string,
    "disabled": PropTypes.bool,
    "disablePortal": PropTypes.bool,
    "draggable": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "enterKeyHint": PropTypes.oneOf(["done", "enter", "go", "next", "previous", "search", "send"]),
    "error": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "fieldHelp": PropTypes.node,
    "form": PropTypes.string,
    "formAction": PropTypes.string,
    "formEncType": PropTypes.string,
    "formMethod": PropTypes.string,
    "formNoValidate": PropTypes.bool,
    "formTarget": PropTypes.string,
    "height": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "helpAriaLabel": PropTypes.string,
    "hidden": PropTypes.bool,
    "id": PropTypes.string,
    "info": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "inlist": PropTypes.any,
    "inputHint": PropTypes.string,
    "inputMode": PropTypes.oneOf(["decimal", "email", "none", "numeric", "search", "tel", "text", "url"]),
    "inputName": PropTypes.oneOf(["end", "start"]),
    "inputWidth": PropTypes.number,
    "is": PropTypes.string,
    "isOptional": PropTypes.bool,
    "itemID": PropTypes.string,
    "itemProp": PropTypes.string,
    "itemRef": PropTypes.string,
    "itemScope": PropTypes.bool,
    "itemType": PropTypes.string,
    "label": PropTypes.string,
    "labelAlign": PropTypes.oneOf(["left", "right"]),
    "labelHelp": PropTypes.node,
    "labelInline": PropTypes.bool,
    "labelSpacing": PropTypes.oneOf([1, 2]),
    "labelWidth": PropTypes.number,
    "lang": PropTypes.string,
    "list": PropTypes.string,
    "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "max": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "maxDate": PropTypes.string,
    "maxLength": PropTypes.number,
    "maxWidth": PropTypes.string,
    "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "min": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "minDate": PropTypes.string,
    "minLength": PropTypes.number,
    "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "multiple": PropTypes.bool,
    "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "name": PropTypes.string,
    "nonce": PropTypes.string,
    "onAbort": PropTypes.func,
    "onAbortCapture": PropTypes.func,
    "onAnimationEnd": PropTypes.func,
    "onAnimationEndCapture": PropTypes.func,
    "onAnimationIteration": PropTypes.func,
    "onAnimationIterationCapture": PropTypes.func,
    "onAnimationStart": PropTypes.func,
    "onAnimationStartCapture": PropTypes.func,
    "onAuxClick": PropTypes.func,
    "onAuxClickCapture": PropTypes.func,
    "onBeforeInput": PropTypes.func,
    "onBeforeInputCapture": PropTypes.func,
    "onBlur": PropTypes.func,
    "onBlurCapture": PropTypes.func,
    "onCanPlay": PropTypes.func,
    "onCanPlayCapture": PropTypes.func,
    "onCanPlayThrough": PropTypes.func,
    "onCanPlayThroughCapture": PropTypes.func,
    "onChange": PropTypes.func.isRequired,
    "onChangeCapture": PropTypes.func,
    "onClick": PropTypes.func,
    "onClickCapture": PropTypes.func,
    "onCompositionEnd": PropTypes.func,
    "onCompositionEndCapture": PropTypes.func,
    "onCompositionStart": PropTypes.func,
    "onCompositionStartCapture": PropTypes.func,
    "onCompositionUpdate": PropTypes.func,
    "onCompositionUpdateCapture": PropTypes.func,
    "onContextMenu": PropTypes.func,
    "onContextMenuCapture": PropTypes.func,
    "onCopy": PropTypes.func,
    "onCopyCapture": PropTypes.func,
    "onCut": PropTypes.func,
    "onCutCapture": PropTypes.func,
    "onDoubleClick": PropTypes.func,
    "onDoubleClickCapture": PropTypes.func,
    "onDrag": PropTypes.func,
    "onDragCapture": PropTypes.func,
    "onDragEnd": PropTypes.func,
    "onDragEndCapture": PropTypes.func,
    "onDragEnter": PropTypes.func,
    "onDragEnterCapture": PropTypes.func,
    "onDragExit": PropTypes.func,
    "onDragExitCapture": PropTypes.func,
    "onDragLeave": PropTypes.func,
    "onDragLeaveCapture": PropTypes.func,
    "onDragOver": PropTypes.func,
    "onDragOverCapture": PropTypes.func,
    "onDragStart": PropTypes.func,
    "onDragStartCapture": PropTypes.func,
    "onDrop": PropTypes.func,
    "onDropCapture": PropTypes.func,
    "onDurationChange": PropTypes.func,
    "onDurationChangeCapture": PropTypes.func,
    "onEmptied": PropTypes.func,
    "onEmptiedCapture": PropTypes.func,
    "onEncrypted": PropTypes.func,
    "onEncryptedCapture": PropTypes.func,
    "onEnded": PropTypes.func,
    "onEndedCapture": PropTypes.func,
    "onError": PropTypes.func,
    "onErrorCapture": PropTypes.func,
    "onFocus": PropTypes.func,
    "onFocusCapture": PropTypes.func,
    "onGotPointerCapture": PropTypes.func,
    "onGotPointerCaptureCapture": PropTypes.func,
    "onInput": PropTypes.func,
    "onInputCapture": PropTypes.func,
    "onInvalid": PropTypes.func,
    "onInvalidCapture": PropTypes.func,
    "onKeyDown": PropTypes.func,
    "onKeyDownCapture": PropTypes.func,
    "onKeyPress": PropTypes.func,
    "onKeyPressCapture": PropTypes.func,
    "onKeyUp": PropTypes.func,
    "onKeyUpCapture": PropTypes.func,
    "onLoad": PropTypes.func,
    "onLoadCapture": PropTypes.func,
    "onLoadedData": PropTypes.func,
    "onLoadedDataCapture": PropTypes.func,
    "onLoadedMetadata": PropTypes.func,
    "onLoadedMetadataCapture": PropTypes.func,
    "onLoadStart": PropTypes.func,
    "onLoadStartCapture": PropTypes.func,
    "onLostPointerCapture": PropTypes.func,
    "onLostPointerCaptureCapture": PropTypes.func,
    "onMouseDownCapture": PropTypes.func,
    "onMouseEnter": PropTypes.func,
    "onMouseLeave": PropTypes.func,
    "onMouseMove": PropTypes.func,
    "onMouseMoveCapture": PropTypes.func,
    "onMouseOut": PropTypes.func,
    "onMouseOutCapture": PropTypes.func,
    "onMouseOver": PropTypes.func,
    "onMouseOverCapture": PropTypes.func,
    "onMouseUp": PropTypes.func,
    "onMouseUpCapture": PropTypes.func,
    "onPaste": PropTypes.func,
    "onPasteCapture": PropTypes.func,
    "onPause": PropTypes.func,
    "onPauseCapture": PropTypes.func,
    "onPlay": PropTypes.func,
    "onPlayCapture": PropTypes.func,
    "onPlaying": PropTypes.func,
    "onPlayingCapture": PropTypes.func,
    "onPointerCancel": PropTypes.func,
    "onPointerCancelCapture": PropTypes.func,
    "onPointerDown": PropTypes.func,
    "onPointerDownCapture": PropTypes.func,
    "onPointerEnter": PropTypes.func,
    "onPointerEnterCapture": PropTypes.func,
    "onPointerLeave": PropTypes.func,
    "onPointerLeaveCapture": PropTypes.func,
    "onPointerMove": PropTypes.func,
    "onPointerMoveCapture": PropTypes.func,
    "onPointerOut": PropTypes.func,
    "onPointerOutCapture": PropTypes.func,
    "onPointerOver": PropTypes.func,
    "onPointerOverCapture": PropTypes.func,
    "onPointerUp": PropTypes.func,
    "onPointerUpCapture": PropTypes.func,
    "onProgress": PropTypes.func,
    "onProgressCapture": PropTypes.func,
    "onRateChange": PropTypes.func,
    "onRateChangeCapture": PropTypes.func,
    "onReset": PropTypes.func,
    "onResetCapture": PropTypes.func,
    "onScroll": PropTypes.func,
    "onScrollCapture": PropTypes.func,
    "onSeeked": PropTypes.func,
    "onSeekedCapture": PropTypes.func,
    "onSeeking": PropTypes.func,
    "onSeekingCapture": PropTypes.func,
    "onSelect": PropTypes.func,
    "onSelectCapture": PropTypes.func,
    "onStalled": PropTypes.func,
    "onStalledCapture": PropTypes.func,
    "onSubmit": PropTypes.func,
    "onSubmitCapture": PropTypes.func,
    "onSuspend": PropTypes.func,
    "onSuspendCapture": PropTypes.func,
    "onTimeUpdate": PropTypes.func,
    "onTimeUpdateCapture": PropTypes.func,
    "onTouchCancel": PropTypes.func,
    "onTouchCancelCapture": PropTypes.func,
    "onTouchEnd": PropTypes.func,
    "onTouchEndCapture": PropTypes.func,
    "onTouchMove": PropTypes.func,
    "onTouchMoveCapture": PropTypes.func,
    "onTouchStart": PropTypes.func,
    "onTouchStartCapture": PropTypes.func,
    "onTransitionEnd": PropTypes.func,
    "onTransitionEndCapture": PropTypes.func,
    "onVolumeChange": PropTypes.func,
    "onVolumeChangeCapture": PropTypes.func,
    "onWaiting": PropTypes.func,
    "onWaitingCapture": PropTypes.func,
    "onWheel": PropTypes.func,
    "onWheelCapture": PropTypes.func,
    "pattern": PropTypes.string,
    "pickerProps": PropTypes.shape({
      "canChangeMonth": PropTypes.bool,
      "captionElement": PropTypes.oneOfType([PropTypes.element, PropTypes.func, PropTypes.shape({
        "childContextTypes": PropTypes.object,
        "contextType": PropTypes.shape({
          "Consumer": PropTypes.func.isRequired,
          "displayName": PropTypes.string,
          "Provider": PropTypes.func.isRequired
        }),
        "contextTypes": PropTypes.object,
        "defaultProps": PropTypes.shape({
          "classNames": PropTypes.object,
          "date": PropTypes.instanceOf(Date),
          "locale": PropTypes.string,
          "localeUtils": PropTypes.object,
          "months": PropTypes.arrayOf(PropTypes.string),
          "onClick": PropTypes.func
        }),
        "displayName": PropTypes.string,
        "getDerivedStateFromError": PropTypes.func,
        "getDerivedStateFromProps": PropTypes.func,
        "propTypes": PropTypes.shape({
          "classNames": PropTypes.func,
          "date": PropTypes.func,
          "locale": PropTypes.func,
          "localeUtils": PropTypes.func,
          "months": PropTypes.func,
          "onClick": PropTypes.func
        })
      })]),
      "className": PropTypes.string,
      "classNames": PropTypes.shape({
        "body": PropTypes.string.isRequired,
        "caption": PropTypes.string.isRequired,
        "container": PropTypes.string.isRequired,
        "day": PropTypes.string.isRequired,
        "disabled": PropTypes.string.isRequired,
        "footer": PropTypes.string.isRequired,
        "interactionDisabled": PropTypes.string.isRequired,
        "month": PropTypes.string.isRequired,
        "months": PropTypes.string.isRequired,
        "navBar": PropTypes.string.isRequired,
        "navButtonInteractionDisabled": PropTypes.string.isRequired,
        "navButtonNext": PropTypes.string.isRequired,
        "navButtonPrev": PropTypes.string.isRequired,
        "outside": PropTypes.string.isRequired,
        "selected": PropTypes.string.isRequired,
        "today": PropTypes.string.isRequired,
        "todayButton": PropTypes.string.isRequired,
        "week": PropTypes.string.isRequired,
        "weekday": PropTypes.string.isRequired,
        "weekdays": PropTypes.string.isRequired,
        "weekdaysRow": PropTypes.string.isRequired,
        "weekNumber": PropTypes.string.isRequired,
        "wrapper": PropTypes.string.isRequired
      }),
      "containerProps": PropTypes.object,
      "dir": PropTypes.string,
      "disabledDays": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.instanceOf(Date), PropTypes.shape({
        "from": PropTypes.instanceOf(Date),
        "to": PropTypes.instanceOf(Date)
      })])), PropTypes.func, PropTypes.instanceOf(Date), PropTypes.shape({
        "from": PropTypes.instanceOf(Date),
        "to": PropTypes.instanceOf(Date)
      })]),
      "enableOutsideDaysClick": PropTypes.bool,
      "firstDayOfWeek": PropTypes.number,
      "fixedWeeks": PropTypes.bool,
      "fromMonth": PropTypes.instanceOf(Date),
      "initialMonth": PropTypes.instanceOf(Date),
      "labels": PropTypes.shape({
        "nextMonth": PropTypes.string.isRequired,
        "previousMonth": PropTypes.string.isRequired
      }),
      "locale": PropTypes.string,
      "localeUtils": PropTypes.shape({
        "formatDate": PropTypes.func.isRequired,
        "formatDay": PropTypes.func.isRequired,
        "formatMonthTitle": PropTypes.func.isRequired,
        "formatWeekdayLong": PropTypes.func.isRequired,
        "formatWeekdayShort": PropTypes.func.isRequired,
        "getFirstDayOfWeek": PropTypes.func.isRequired,
        "getMonths": PropTypes.func.isRequired,
        "parseDate": PropTypes.func.isRequired
      }),
      "modifiers": PropTypes.shape({
        "outside": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.instanceOf(Date), PropTypes.shape({
          "from": PropTypes.instanceOf(Date),
          "to": PropTypes.instanceOf(Date)
        })])), PropTypes.func, PropTypes.instanceOf(Date), PropTypes.shape({
          "from": PropTypes.instanceOf(Date),
          "to": PropTypes.instanceOf(Date)
        })]),
        "today": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.instanceOf(Date), PropTypes.shape({
          "from": PropTypes.instanceOf(Date),
          "to": PropTypes.instanceOf(Date)
        })])), PropTypes.func, PropTypes.instanceOf(Date), PropTypes.shape({
          "from": PropTypes.instanceOf(Date),
          "to": PropTypes.instanceOf(Date)
        })])
      }),
      "modifiersStyles": PropTypes.object,
      "month": PropTypes.instanceOf(Date),
      "months": PropTypes.arrayOf(PropTypes.string),
      "navbarElement": PropTypes.oneOfType([PropTypes.element, PropTypes.func, PropTypes.shape({
        "childContextTypes": PropTypes.object,
        "contextType": PropTypes.shape({
          "Consumer": PropTypes.func.isRequired,
          "displayName": PropTypes.string,
          "Provider": PropTypes.func.isRequired
        }),
        "contextTypes": PropTypes.object,
        "defaultProps": PropTypes.shape({
          "className": PropTypes.string,
          "classNames": PropTypes.object,
          "dir": PropTypes.string,
          "labels": PropTypes.object,
          "locale": PropTypes.string,
          "localeUtils": PropTypes.object,
          "month": PropTypes.instanceOf(Date),
          "nextMonth": PropTypes.instanceOf(Date),
          "onNextClick": PropTypes.func,
          "onPreviousClick": PropTypes.func,
          "previousMonth": PropTypes.instanceOf(Date),
          "showNextButton": PropTypes.bool,
          "showPreviousButton": PropTypes.bool
        }),
        "displayName": PropTypes.string,
        "getDerivedStateFromError": PropTypes.func,
        "getDerivedStateFromProps": PropTypes.func,
        "propTypes": PropTypes.shape({
          "className": PropTypes.func,
          "classNames": PropTypes.func,
          "dir": PropTypes.func,
          "labels": PropTypes.func,
          "locale": PropTypes.func,
          "localeUtils": PropTypes.func,
          "month": PropTypes.func,
          "nextMonth": PropTypes.func,
          "onNextClick": PropTypes.func,
          "onPreviousClick": PropTypes.func,
          "previousMonth": PropTypes.func,
          "showNextButton": PropTypes.func,
          "showPreviousButton": PropTypes.func
        })
      })]),
      "numberOfMonths": PropTypes.number,
      "onBlur": PropTypes.func,
      "onCaptionClick": PropTypes.func,
      "onDayClick": PropTypes.func,
      "onDayKeyDown": PropTypes.func,
      "onDayMouseDown": PropTypes.func,
      "onDayMouseEnter": PropTypes.func,
      "onDayMouseLeave": PropTypes.func,
      "onDayMouseUp": PropTypes.func,
      "onDayTouchEnd": PropTypes.func,
      "onDayTouchStart": PropTypes.func,
      "onFocus": PropTypes.func,
      "onKeyDown": PropTypes.func,
      "onMonthChange": PropTypes.func,
      "onTodayButtonClick": PropTypes.func,
      "onWeekClick": PropTypes.func,
      "pagedNavigation": PropTypes.bool,
      "renderDay": PropTypes.func,
      "renderWeek": PropTypes.func,
      "reverseMonths": PropTypes.bool,
      "selectedDays": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.instanceOf(Date), PropTypes.shape({
        "from": PropTypes.instanceOf(Date),
        "to": PropTypes.instanceOf(Date)
      })])), PropTypes.func, PropTypes.instanceOf(Date), PropTypes.shape({
        "from": PropTypes.instanceOf(Date),
        "to": PropTypes.instanceOf(Date)
      })]),
      "showOutsideDays": PropTypes.bool,
      "showWeekDays": PropTypes.bool,
      "showWeekNumbers": PropTypes.bool,
      "tabIndex": PropTypes.number,
      "todayButton": PropTypes.string,
      "toMonth": PropTypes.instanceOf(Date),
      "weekdayElement": PropTypes.oneOfType([PropTypes.element, PropTypes.func, PropTypes.shape({
        "childContextTypes": PropTypes.object,
        "contextType": PropTypes.shape({
          "Consumer": PropTypes.func.isRequired,
          "displayName": PropTypes.string,
          "Provider": PropTypes.func.isRequired
        }),
        "contextTypes": PropTypes.object,
        "defaultProps": PropTypes.shape({
          "className": PropTypes.string,
          "locale": PropTypes.string,
          "localeUtils": PropTypes.object,
          "weekday": PropTypes.number,
          "weekdaysLong": PropTypes.arrayOf(PropTypes.string),
          "weekdaysShort": PropTypes.arrayOf(PropTypes.string)
        }),
        "displayName": PropTypes.string,
        "getDerivedStateFromError": PropTypes.func,
        "getDerivedStateFromProps": PropTypes.func,
        "propTypes": PropTypes.shape({
          "className": PropTypes.func,
          "locale": PropTypes.func,
          "localeUtils": PropTypes.func,
          "weekday": PropTypes.func,
          "weekdaysLong": PropTypes.func,
          "weekdaysShort": PropTypes.func
        })
      })]),
      "weekdaysLong": PropTypes.arrayOf(PropTypes.string),
      "weekdaysShort": PropTypes.arrayOf(PropTypes.string)
    }),
    "positionedChildren": PropTypes.node,
    "prefix": PropTypes.string,
    "property": PropTypes.string,
    "radioGroup": PropTypes.string,
    "readOnly": PropTypes.bool,
    "rel": PropTypes.string,
    "required": PropTypes.bool,
    "resource": PropTypes.string,
    "results": PropTypes.number,
    "rev": PropTypes.string,
    "reverse": PropTypes.bool,
    "role": PropTypes.oneOfType([PropTypes.oneOf(["alert", "alertdialog", "application", "article", "banner", "button", "cell", "checkbox", "columnheader", "combobox", "complementary", "contentinfo", "definition", "dialog", "directory", "document", "feed", "figure", "form", "grid", "gridcell", "group", "heading", "img", "link", "list", "listbox", "listitem", "log", "main", "marquee", "math", "menu", "menubar", "menuitem", "menuitemcheckbox", "menuitemradio", "navigation", "none", "note", "option", "presentation", "progressbar", "radio", "radiogroup", "region", "row", "rowgroup", "rowheader", "scrollbar", "search", "searchbox", "separator", "slider", "spinbutton", "status", "switch", "tab", "table", "tablist", "tabpanel", "term", "textbox", "timer", "toolbar", "tooltip", "tree", "treegrid", "treeitem"]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "security": PropTypes.string,
    "size": PropTypes.oneOf(["large", "medium", "small"]),
    "slot": PropTypes.string,
    "spellCheck": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "src": PropTypes.string,
    "step": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "style": PropTypes.object,
    "suppressContentEditableWarning": PropTypes.bool,
    "suppressHydrationWarning": PropTypes.bool,
    "tabIndex": PropTypes.number,
    "title": PropTypes.string,
    "tooltipPosition": PropTypes.oneOf(["bottom", "left", "right", "top"]),
    "translate": PropTypes.oneOf(["no", "yes"]),
    "typeof": PropTypes.string,
    "unselectable": PropTypes.oneOf(["off", "on"]),
    "validationIconId": PropTypes.string,
    "validationOnLabel": PropTypes.bool,
    "value": PropTypes.string.isRequired,
    "vocab": PropTypes.string,
    "warning": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "width": PropTypes.oneOfType([PropTypes.number, PropTypes.string])
  };
}
export { DateInput };
DateInput.displayName = "DateInput";
export default DateInput;