import React from "react";
import { TextboxProps } from "../textbox";
import { PickerProps } from "./__internal__/date-picker";
import { InputName } from "../date-range/date-range.context";
export interface DateChangeEvent {
    target: {
        id?: string;
        name?: string;
        value: {
            formattedValue: string;
            rawValue: string | null;
        };
    };
}
export interface DateInputProps extends Omit<TextboxProps, "value" | "formattedValue" | "rawValue" | "onChange" | "onBlur" | "onMouseDown" | "onChangeDeferred" | "deferTimeout" | "children" | "leftChildren" | "placeholder" | "iconOnClick" | "iconOnMouseDown" | "characterLimit" | "warnOverLimit" | "iconTabIndex" | "inputIcon"> {
    /** Boolean to allow the input to have an empty value */
    allowEmptyValue?: boolean;
    /** Boolean to toggle where DatePicker is rendered in relation to the Date Input */
    disablePortal?: boolean;
    /** Minimum possible date YYYY-MM-DD */
    minDate?: string;
    /** Maximum possible date YYYY-MM-DD */
    maxDate?: string;
    /** Specify a callback triggered on change */
    onChange: (ev: DateChangeEvent) => void;
    /** Specify a callback triggered on blur */
    onBlur?: (ev: DateChangeEvent) => void;
    /** The current date string */
    value: string;
    /**
     * Pass any props that match the DayPickerProps interface to override default behaviors
     * See [DayPickerProps](https://react-day-picker-v7.netlify.app/docs/getting-started/) for a full list of available props
     * */
    pickerProps?: PickerProps;
    /**
     * @private
     * @ignore
     * Name passed from DateRange to allow it to know which input is updating
     * */
    inputName?: InputName;
}
export declare const DateInput: React.ForwardRefExoticComponent<DateInputProps & React.RefAttributes<HTMLInputElement>>;
export default DateInput;
