import React from "react";
import PropTypes from "prop-types";
import StyledButton from "./button.style";
import StyledNavbar from "./navbar.style";
import Icon from "../../../icon";
import Events from "../../../../__internal__/utils/helpers/events";
import useLocale from "../../../../hooks/__internal__/useLocale";
export const Navbar = ({
  onPreviousClick,
  onNextClick,
  className
}) => {
  const locale = useLocale();
  const {
    previousMonthButton,
    nextMonthButton
  } = locale.date.ariaLabels;
  const handleKeyDown = ev => {
    if (Events.isLeftKey(ev) || Events.isRightKey(ev) || Events.isUpKey(ev) || Events.isDownKey(ev)) {
      ev.stopPropagation();
      ev.preventDefault();
    }
  };
  return /*#__PURE__*/React.createElement(StyledNavbar, {
    className: className
  }, /*#__PURE__*/React.createElement(StyledButton, {
    "aria-label": previousMonthButton(),
    onClick: () => onPreviousClick?.(),
    onKeyDown: handleKeyDown
  }, /*#__PURE__*/React.createElement(Icon, {
    type: "chevron_left"
  })), /*#__PURE__*/React.createElement(StyledButton, {
    "aria-label": nextMonthButton(),
    onClick: () => onNextClick?.(),
    onKeyDown: handleKeyDown
  }, /*#__PURE__*/React.createElement(Icon, {
    type: "chevron_right"
  })));
};
export default Navbar;