function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useEffect, useMemo, useRef } from "react";
import PropTypes from "prop-types";
import DayPicker from "react-day-picker";
import { flip, offset } from "@floating-ui/dom";
import { getDisabledDays } from "../utils";
import Popover from "../../../../__internal__/popover";
import useLocale from "../../../../hooks/__internal__/useLocale";
import Navbar from "../navbar";
import Weekday from "../weekday";
import StyledDayPicker from "./day-picker.style";
import Events from "../../../../__internal__/utils/helpers/events";
import { defaultFocusableSelectors } from "../../../../__internal__/focus-trap/focus-trap-utils";

/** there is an issue with typescript-to-proptypes package that means we need to override these types */

const popoverMiddleware = [offset(3), flip({
  fallbackStrategy: "initialPlacement"
})];
export const DatePicker = ({
  inputElement,
  minDate,
  maxDate,
  selectedDays,
  disablePortal,
  onDayClick,
  pickerMouseDown,
  pickerProps,
  open,
  setOpen,
  pickerTabGuardId
}) => {
  const l = useLocale();
  const {
    localize,
    options
  } = l.date.dateFnsLocale();
  const {
    weekStartsOn
  } = options || /* istanbul ignore next */{};
  const monthsLong = useMemo(() => Array.from({
    length: 12
  }).map((_, i) => {
    const month = localize?.month(i);
    return month[0].toUpperCase() + month.slice(1);
  }), [localize]);
  const monthsShort = useMemo(() => Array.from({
    length: 12
  }).map((_, i) => localize?.month(i, {
    width: "abbreviated"
  }).substring(0, 3)), [localize]);
  const weekdaysLong = useMemo(() => Array.from({
    length: 7
  }).map((_, i) => localize?.day(i)), [localize]);
  const weekdaysShort = useMemo(() => {
    const isGivenLocale = str => l.locale().includes(str);
    return Array.from({
      length: 7
    }).map((_, i) => localize?.day(i, ["de", "pl"].some(isGivenLocale) ? {
      width: "wide"
    } : {
      width: "abbreviated"
    }).substring(0, isGivenLocale("de") ? 2 : 3));
  }, [l, localize]);
  const ref = useRef(null);
  useEffect(() => {
    if (open) {
      // this is a temporary fix for some axe issues that are baked into the library we use for the picker
      const captionElement = ref.current?.querySelector(".DayPicker-Caption");
      /* istanbul ignore else */
      if (captionElement) {
        captionElement.removeAttribute("role");
        captionElement.removeAttribute("aria-live");
      }

      // focus the selected or today's date first
      const selectedDay = ref.current?.querySelector(".DayPicker-Day--selected") || ref.current?.querySelector(".DayPicker-Day--today");
      const firstDay = ref.current?.querySelector(".DayPicker-Day[tabindex='0']");

      /* istanbul ignore else */
      if (selectedDay && firstDay !== selectedDay) {
        selectedDay?.setAttribute("tabindex", "0");
        firstDay?.setAttribute("tabindex", "-1");
      }
    }
  }, [open]);
  const handleDayClick = (date, modifiers, ev) => {
    if (!modifiers.disabled) {
      const {
        id,
        name
      } = inputElement?.current?.firstChild;
      ev.target = {
        ...ev.target,
        id,
        name
      };
      onDayClick?.(date, ev);
    }
  };
  const handleKeyUp = useCallback(ev => {
    /* istanbul ignore else */
    if (open && Events.isEscKey(ev)) {
      inputElement.current?.querySelector("input")?.focus();
      setOpen(false);
      ev.stopPropagation();
    }
  }, [inputElement, open, setOpen]);
  const handleOnKeyDown = ev => {
    /* istanbul ignore else */
    if (ref.current?.querySelector(".DayPicker-NavBar button") === document.activeElement && Events.isTabKey(ev) && Events.isShiftKey(ev)) {
      ev.preventDefault();
      setOpen(false);
      inputElement.current?.querySelector("input")?.focus();
    }
  };
  const handleOnDayKeyDown = (_day, _modifiers, ev) => {
    // we need to manually handle this as the picker may be in a Portal
    /* istanbul ignore else */
    if (Events.isTabKey(ev) && !Events.isShiftKey(ev)) {
      ev.preventDefault();
      setOpen(false);
      const input = inputElement.current?.querySelector("input");

      /* istanbul ignore else */
      if (input) {
        const elements = Array.from(document.querySelectorAll(defaultFocusableSelectors) || /* istanbul ignore next */[]);
        const elementsInPicker = Array.from(ref.current?.querySelectorAll("button, [tabindex]") || /* istanbul ignore next */[]);
        const filteredElements = elements.filter(el => Number(el.tabIndex) !== -1 && !elementsInPicker.includes(el));
        const nextIndex = filteredElements.indexOf(input) + 1;
        filteredElements[nextIndex]?.focus();
      }
    }
  };
  const formatDay = date => `${weekdaysShort[date.getDay()]} ${date.getDate()} ${monthsShort[date.getMonth()]} ${date.getFullYear()}`;
  if (!open) {
    return null;
  }
  const localeUtils = {
    formatDay
  };
  const handleTabGuardFocus = () => {
    ref.current?.querySelector("button")?.focus();
  };
  return /*#__PURE__*/React.createElement(Popover, {
    placement: "bottom-start",
    reference: inputElement,
    middleware: popoverMiddleware,
    disablePortal: disablePortal
  }, /*#__PURE__*/React.createElement(StyledDayPicker, {
    ref: ref,
    onMouseDown: pickerMouseDown,
    onKeyUp: handleKeyUp,
    onKeyDown: handleOnKeyDown
  }, /*#__PURE__*/React.createElement("div", {
    id: pickerTabGuardId
    // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
    ,
    tabIndex: 0,
    onFocus: handleTabGuardFocus
  }), /*#__PURE__*/React.createElement(DayPicker, _extends({
    month: selectedDays,
    months: monthsLong,
    firstDayOfWeek: weekStartsOn,
    onDayClick: handleDayClick,
    selectedDays: selectedDays,
    weekdayElement: weekdayElementProps => {
      const {
        className,
        weekday
      } = weekdayElementProps;
      return /*#__PURE__*/React.createElement(Weekday, {
        className: className,
        title: weekdaysLong[weekday]
      }, weekdaysShort[weekday]);
    },
    navbarElement: /*#__PURE__*/React.createElement(Navbar, null),
    fixedWeeks: true,
    initialMonth: selectedDays || undefined,
    disabledDays: getDisabledDays(minDate, maxDate),
    locale: l.locale(),
    localeUtils: localeUtils,
    onDayKeyDown: handleOnDayKeyDown
  }, pickerProps))));
};
DatePicker.displayName = "DatePicker";
export default DatePicker;