import React from "react";
import { DayPickerProps, Modifier } from "react-day-picker";
declare type CustomRefObject<T> = {
    current?: T | null;
};
/** there is an issue with typescript-to-proptypes package that means we need to override these types */
interface Modifiers {
    today: NonNullable<Modifier> | NonNullable<Modifier>[];
    outside: NonNullable<Modifier> | NonNullable<Modifier>[];
    [other: string]: NonNullable<Modifier> | NonNullable<Modifier>[];
}
export interface PickerProps extends Omit<DayPickerProps, "disabledDays" | "modifiers" | "selectedDays"> {
    disabledDays?: NonNullable<Modifier> | NonNullable<Modifier>[] | undefined[];
    modifiers?: Partial<Modifiers>;
    selectedDays?: NonNullable<Modifier> | NonNullable<Modifier>[] | undefined[];
}
export interface DatePickerProps {
    /** Boolean to toggle where DatePicker is rendered in relation to the Date Input */
    disablePortal?: boolean;
    /** Minimum possible date YYYY-MM-DD */
    minDate?: string;
    /** Maximum possible date YYYY-MM-DD */
    maxDate?: string;
    /** Pass any props that match the DayPickerProps interface to override default behaviors */
    pickerProps?: PickerProps;
    /** Element that the DatePicker will be displayed under */
    inputElement: CustomRefObject<HTMLElement>;
    /** Currently selected date */
    selectedDays?: Date;
    /** Callback to handle mousedown event on picker container */
    pickerMouseDown?: () => void;
    /** Sets whether the picker should be displayed */
    open?: boolean;
    /** Callback triggered when a Day is clicked */
    onDayClick?: (date: Date, ev: React.MouseEvent<HTMLDivElement>) => void;
    /** Sets the picker open state */
    setOpen: (isOpen: boolean) => void;
    /** Id passed to tab guard element */
    pickerTabGuardId?: string;
}
export declare const DatePicker: {
    ({ inputElement, minDate, maxDate, selectedDays, disablePortal, onDayClick, pickerMouseDown, pickerProps, open, setOpen, pickerTabGuardId, }: DatePickerProps): React.JSX.Element | null;
    displayName: string;
};
export default DatePicker;
