import React from "react";
export declare type InputName = "start" | "end";
declare type IsBlurBlocked = {
    current: boolean;
};
declare type SetOpen = null | ((value: boolean) => void);
export declare type SetInputRefMapValue = {
    [id in InputName]?: {
        isBlurBlocked: IsBlurBlocked;
        setOpen: SetOpen;
    };
};
interface DateInputRefMap {
    isBlurBlocked: IsBlurBlocked;
    setOpen: SetOpen;
}
export interface DateRangeContextProps {
    inputRefMap?: Partial<Record<InputName, DateInputRefMap>>;
    setInputRefMap?: (value: SetInputRefMapValue) => void;
}
declare const _default: React.Context<DateRangeContextProps>;
export default _default;
