function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useEffect, useMemo, useState } from "react";
import PropTypes from "prop-types";
import { formatToISO, formattedValue, parseISODate, checkISOFormatAndLength } from "../date/__internal__/utils";
import DateInput from "../date";
import { filterStyledSystemMarginProps } from "../../style/utils";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import StyledDateRange from "./date-range.style";
import Events from "../../__internal__/utils/helpers/events";
import useLocale from "../../hooks/__internal__/useLocale";
import usePrevious from "../../hooks/__internal__/usePrevious";
import getFormatData from "../date/__internal__/date-formats";
import DateRangeContext from "./date-range.context";
export const DateRange = ({
  endDateProps = {},
  id,
  labelsInline,
  name,
  onBlur,
  onChange,
  startDateProps = {},
  tooltipPosition,
  validationOnLabel,
  value,
  startRef,
  endRef,
  required,
  isOptional,
  ...rest
}) => {
  const l = useLocale();
  const {
    dateFnsLocale
  } = l.date;
  const {
    format
  } = useMemo(() => getFormatData(dateFnsLocale()), [dateFnsLocale]);
  const inlineLabelWidth = 40;
  const [lastChangedDate, setLastChangedDate] = useState("");
  const computedValue = useCallback(valueString => {
    if (checkISOFormatAndLength(valueString)) {
      return formattedValue(format, parseISODate(valueString));
    }
    return valueString;
  }, [format]);
  const getStartDate = useCallback(() => {
    const {
      value: startValue
    } = startDateProps;
    return computedValue(startValue || value[0]);
  }, [startDateProps, value, computedValue]);
  const getEndDate = useCallback(() => {
    const {
      value: endValue
    } = endDateProps;
    return computedValue(endValue || value[1]);
  }, [endDateProps, value, computedValue]);
  const [inputRefMap, setInputRefMap] = useState({
    start: {
      isBlurBlocked: {
        current: false
      },
      setOpen: null
    },
    end: {
      isBlurBlocked: {
        current: false
      },
      setOpen: null
    }
  });
  function isEmptyValue(allowEmpty, inputValue) {
    return allowEmpty && !inputValue.length;
  }
  const [startDateValue, setStartDateValue] = useState({
    formattedValue: getStartDate(),
    rawValue: isEmptyValue(!!startDateProps.allowEmptyValue, getStartDate()) ? "" : formatToISO(format, getStartDate())
  });
  const [endDateValue, setEndDateValue] = useState({
    formattedValue: getEndDate(),
    rawValue: isEmptyValue(!!endDateProps.allowEmptyValue, getEndDate()) ? "" : formatToISO(format, getEndDate())
  });
  const previousValue = usePrevious(value);
  useEffect(() => {
    const updateValues = () => {
      setStartDateValue({
        formattedValue: getStartDate(),
        rawValue: isEmptyValue(!!startDateProps.allowEmptyValue, getStartDate()) ? "" : formatToISO(format, getStartDate())
      });
      setEndDateValue({
        formattedValue: getEndDate(),
        rawValue: isEmptyValue(!!endDateProps.allowEmptyValue, getEndDate()) ? "" : formatToISO(format, getEndDate())
      });
    };
    const hasPreviousValues = previousValue?.length;
    const hasUpdated = hasPreviousValues && (value[0] !== previousValue[0] || value[1] !== previousValue[1]);
    if (hasUpdated) {
      updateValues();
    }
  }, [value, previousValue, endDateProps.allowEmptyValue, format, getEndDate, getStartDate, startDateProps.allowEmptyValue]);
  const buildCustomEvent = useCallback((changedDate, newValue) => {
    const startValue = changedDate === "start" ? newValue : startDateValue;
    const endValue = changedDate === "end" ? newValue : endDateValue;
    setLastChangedDate(changedDate);
    return {
      target: {
        ...(name && {
          name
        }),
        ...(id && {
          id
        }),
        value: [startValue, endValue]
      }
    };
  }, [endDateValue, id, name, startDateValue]);
  const handleOnChange = (changedDate, ev) => {
    if (changedDate === "start") {
      setStartDateValue({
        ...ev.target.value
      });
    } else {
      setEndDateValue({
        ...ev.target.value
      });
    }
    const event = buildCustomEvent(changedDate, ev.target.value);
    onChange(event);
  };
  const startDateOnChange = ev => {
    handleOnChange("start", ev);
  };
  const endDateOnChange = ev => {
    handleOnChange("end", ev);
  };
  const updateInputMap = newState => {
    setInputRefMap(prev => {
      return {
        ...prev,
        ...newState
      };
    });
  };
  const isBlurBlocked = () => inputRefMap?.start?.isBlurBlocked.current || inputRefMap?.end?.isBlurBlocked.current;
  const handleOnBlur = ev => {
    if (isBlurBlocked()) {
      return;
    }
    if (onBlur) {
      const event = buildCustomEvent(lastChangedDate, ev.target.value);
      onBlur(event);
    }
  };
  const closePicker = activeInput => {
    const refMap = inputRefMap?.[activeInput];

    /* istanbul ignore else */
    if (refMap) {
      refMap.setOpen?.(false);
      refMap.isBlurBlocked.current = false;
    }
  };
  const handleOnKeyDown = (ev, activeInput) => {
    if (Events.isTabKey(ev) && Events.isShiftKey(ev) && inputRefMap?.start) {
      inputRefMap.start.isBlurBlocked.current = !(activeInput === "start");
    } else if (Events.isTabKey(ev) && inputRefMap?.end) {
      inputRefMap.end.isBlurBlocked.current = !(activeInput === "end");
    }
  };
  const handleFocus = inputName => {
    closePicker(inputName);
    setLastChangedDate(inputName === "start" ? "end" : "start");
  };
  const dateProps = propsKey => {
    const props = propsKey === "start" ? startDateProps : endDateProps;
    const {
      formattedValue: inputValue
    } = propsKey === "start" ? startDateValue : endDateValue;
    const onChangeCallback = propsKey === "start" ? startDateOnChange : endDateOnChange;
    return {
      label: rest[`${propsKey}Label`],
      labelInline: labelsInline,
      value: inputValue,
      error: rest[`${propsKey}Error`],
      warning: rest[`${propsKey}Warning`],
      info: rest[`${propsKey}Info`],
      validationOnLabel,
      onBlur: handleOnBlur,
      onChange: onChangeCallback,
      onKeyDown: ev => handleOnKeyDown(ev, propsKey),
      ...props,
      required,
      isOptional
    };
  };
  return /*#__PURE__*/React.createElement(StyledDateRange, _extends({}, tagComponent("date-range", rest), {
    labelsInline: labelsInline
  }, filterStyledSystemMarginProps(rest)), /*#__PURE__*/React.createElement(DateRangeContext.Provider, {
    value: {
      inputRefMap,
      setInputRefMap: updateInputMap
    }
  }, /*#__PURE__*/React.createElement(DateInput, _extends({
    my: 0 // prevents any form spacing being applied
  }, dateProps("start"), {
    onFocus: () => handleFocus("end"),
    "data-element": "start-date",
    inputName: "start",
    labelWidth: inlineLabelWidth // Textbox only applies this when labelsInLine prop is true
    ,
    tooltipPosition: tooltipPosition,
    ref: startRef
  })), /*#__PURE__*/React.createElement(DateInput, _extends({
    my: 0 // prevents any form spacing being applied
  }, dateProps("end"), {
    onFocus: () => handleFocus("start"),
    "data-element": "end-date",
    inputName: "end",
    labelWidth: inlineLabelWidth // Textbox only applies this when labelsInLine prop is true
    ,
    tooltipPosition: tooltipPosition,
    ref: endRef
  }))));
};
DateRange.displayName = "DateRange";
export default DateRange;