function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import { StyledContent, StyledContentTitle, StyledContentBody } from "./content.style";
export const Content = ({
  variant = "primary",
  children,
  title,
  inline = false,
  align = "left",
  titleWidth,
  bodyFullWidth = false,
  ...rest
}) => {
  return /*#__PURE__*/React.createElement(StyledContent, _extends({
    align: align,
    bodyFullWidth: bodyFullWidth
  }, rest, {
    "data-component": "content"
  }), /*#__PURE__*/React.createElement(StyledContentTitle, {
    variant: variant,
    inline: inline,
    "data-element": "content-title",
    titleWidth: titleWidth,
    align: align
  }, title), /*#__PURE__*/React.createElement(StyledContentBody, {
    variant: variant,
    inline: inline,
    "data-element": "content-body",
    bodyFullWidth: bodyFullWidth,
    titleWidth: titleWidth,
    align: align
  }, children));
};
Content.displayName = "Content";
export default Content;